/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPropertyAccessor
extends KtDeclarationStub<KotlinPropertyAccessorStub>
implements KtDeclarationWithBody,
KtDeclarationWithInitializer,
KtModifierListOwner {
    public KtPropertyAccessor(@NotNull ASTNode node) {
        super(node);
    }

    public KtPropertyAccessor(@NotNull KotlinPropertyAccessorStub stub) {
        super(stub, KtStubElementTypes.PROPERTY_ACCESSOR);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitPropertyAccessor(this, data);
    }

    public boolean isSetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return !stub.isGetter();
        }
        return this.findChildByType(KtTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.isGetter();
        }
        return this.findChildByType(KtTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public KtParameterList getParameterList() {
        return (KtParameterList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Nullable
    public KtParameter getParameter() {
        KtParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            return null;
        }
        List<KtParameter> parameters2 = parameterList.getParameters();
        if (parameters2.isEmpty()) {
            return null;
        }
        return parameters2.get(0);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameter parameter = this.getParameter();
        if (parameter == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parameter);
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @Override
    public boolean hasBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Nullable
    public KtTypeReference getReturnTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        Object get2 = this.findChildByType(KtTokens.GET_KEYWORD);
        if (get2 != null) {
            return get2;
        }
        return this.findChildByType(KtTokens.SET_KEYWORD);
    }

    @Nullable
    public ASTNode getRightParenthesis() {
        return this.getNode().findChildByType(KtTokens.RPAR);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @NotNull
    public KtProperty getProperty() {
        return (KtProperty)this.getParent();
    }
}

