
#ifndef _FADE_H
#define _FADE_H

#define TIMER_OFF ~0UL

void fadeTo( int secs, byte r, byte g, byte b, byte w = 0, byte w2 = 0 );

#include "config.h"
#include "rgbled.h"

struct Fade
{
  public:
    long duration;
    unsigned long start;

    int notify_timeout;
    unsigned long last_notify;

    byte to[5];
    int diff[5];

    inline Fade() : duration(0) {start = TIMER_OFF;};
};

extern Fade fade;

extern byte current_fade_reg;
extern byte fade_start;
extern byte fade_end;

inline void fadeStop() {fade.start = TIMER_OFF;};
inline bool isFading() {return fade.start != TIMER_OFF;};
inline bool inFade() {return fade_start != fade_end;};
#endif
