#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int tree_change_branch_type(t, ty, bt)
tree t;
tree_type ty;
branch_type bt;
{
	list n;

	globals->bt=bt;
	ttdta(t, ty)->bt=bt;
	invalidate_spacing(t, ty);
	return(1);
}

int set_font_of_scale_bar(t, ty, f)
tree t;
tree_type ty;
tfont f;
{
	treetypedata td;
	int tmp;
	int x, y;

	td=ttdta(t, ty);
	td->pfont=f;
	tcontext_set_font(td->gc, f);
	ttext_change_font(td->percent, f);
	center_scale_bar_text(td);
	modify();
	return(1);
}

int set_color_of_scale_bar(t, ty, c)
tree t;
tree_type ty;
tcolor c;
{
	treetypedata td;

	td=ttdta(t, ty);
	td->c=c;
	tcontext_set_foreground(td->gc, c);
	ttext_set_color(td->percent, c);
	canvas_add_scale_bar(t);
	modify();
	return(1);
}

int tree_show_scale_bar(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	int tmp;

	td=ttdta(t, ty);
	if(!td->showpct)
	{
		td->showpct=1;
		canvas_add_scale_bar(t);
		modify();
	}
	return(1);
}

int tree_hide_scale_bar(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	int tmp;

	td=ttdta(t, ty);
	if(td->showpct)
	{
		td->showpct=0;
		canvas_add_scale_bar(t);
		modify();
	}
	return(1);
}

int tree_show_terminal_names(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	list n;

	td=ttdta(t, ty);
	if(!td->showterminals)
	{
		td->showterminals=1;
		invalidate_refit(t, ty);
		canvas_add_tree(t);
		modify();
	}
	return(1);
}

int tree_hide_terminal_names(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	list n;

	td=ttdta(t, ty);
	if(td->showterminals)
	{
		td->showterminals=0;
		invalidate_refit(t, ty);
		canvas_add_tree(t);
		modify();
	}
	return(1);
}

int tree_show_internal_names(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	list n;

	td=ttdta(t, ty);
	if(!td->showinternals)
	{
		td->showinternals=1;
		invalidate_spacing(t, ty);
		invalidate_refit(t, ty);
		canvas_add_tree(t);
		modify();
	}
	return(1);
}

int tree_hide_internal_names(t, ty)
tree t;
tree_type ty;
{
	treetypedata td;
	list n;

	td=ttdta(t, ty);
	if(td->showinternals)
	{
		td->showinternals=0;
		invalidate_spacing(t, ty);
		invalidate_refit(t, ty);
		canvas_add_tree(t);
		modify();
	}
	return(1);
}

int tree_change_scale(t, ty, scale)
tree t;
tree_type ty;
double scale;
{
	treetypedata td;

	td=ttdta(t, ty);
	if(scale!=td->scale)
	{
		canvas_add_scale_bar(t);
		td->scale=scale;
		center_scale_bar(td);
		canvas_add_scale_bar(t);
		modify();
	}
	return(1);
}

int tree_change_scale_value(t, ty, value)
tree t;
tree_type ty;
double value;
{
	treetypedata td;
	int tmp;
	char buf[50];

	td=ttdta(t, ty);
	if(value!=td->pv)
	{
		canvas_add_scale_bar(t);
		ttext_set_selection(td->percent, -1, -1);
		sprintf(buf, "%.2lf", value);
		ttext_insert_string(td->percent, buf);
		td->pv=value;
		center_scale_bar_text(td);
		center_scale_bar(td);
		canvas_add_scale_bar(t);
		modify();
	}
	return(1);
}

int tree_move_scale_bar(t, ty, x, y)
tree t;
tree_type ty;
int x, y;
{
	treetypedata td;
	int tmp;
	int nx, ny;

	td=ttdta(t, ty);
	if(x!=td->x || y!=td->y)
	{
		canvas_add_scale_bar(t);
		td->px=x;
		td->py=y;
		center_scale_bar(td);
		center_scale_bar_text(td);
		canvas_add_scale_bar(t);
		td->percentisreset=0;
		modify();
	}
	return(1);
}

int set_tree_type(t, type)
tree t;
tree_type type;
{
	list c;

	canvas_add_tree(t);
	tdta(t)->type=type;
	globals->type=type;
	switch(type)
	{
		case Flower:
			/* setup td pointers to flower for tree, nodes and branches */
			tdta(t)->td=tdta(t)->flower;
			lfor(t->nodes, c)
				ndta(nodeobj(c))->td=ndta(nodeobj(c))->flower;
			lfor(t->branches, c)
				bdta(nodeobj(c))->td=bdta(nodeobj(c))->flower;
			break;
		case Boxed:
		default:
			/* setup td pointers to boxed for tree, nodes and branches */
			tdta(t)->td=tdta(t)->boxed;
			lfor(t->nodes, c)
				ndta(nodeobj(c))->td=ndta(nodeobj(c))->boxed;
			lfor(t->branches, c)
				bdta(nodeobj(c))->td=bdta(nodeobj(c))->boxed;
			break;
	}
	canvas_add_tree(t);
}

center_scale_bar_text(td)
treetypedata td;
{
	int x, y;

	x=td->px-ttext_width(td->percent)/2;
	y=td->py-ttext_height(td->percent)-5;
	ttext_move(td->percent, x, y);
}

center_scale_bar(td)
treetypedata td;
{
	int x, y;

	td->plw=td->pv*td->scale*td->tscalex;
	td->plx=td->px-td->plw/2;
	td->ply=td->py;
}
