package test.contrib;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.*;

import javax.swing.*;

public class ScrollResizeProblemFrame extends JDialog {
	public static void main(String[] args) {
//		try {
//			UIManager.setLookAndFeel(new MetalLookAndFeel());
//		} catch (UnsupportedLookAndFeelException e) {
//
//		}

		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new CreateGUI());
	}

	private static class CreateGUI implements Runnable {
		public void run() {
			final JFrame frame = new JFrame("Test");
			frame.setPreferredSize(new Dimension(400, 300));

			JPanel mainPanel = new JPanel();
			JButton button1 = new JButton("Dialog");

			button1.addActionListener(new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							new Dialog(frame);
						}
					});

				}
			});

			mainPanel.add(button1);

			frame.getContentPane().add(mainPanel);
			frame.pack();
			frame.setVisible(true);
		}
	}

	private static class Dialog extends JDialog {
		Dialog(Frame owner) {
			super(owner);

			JPanel panel = new JPanel();

			panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory
					.createTitledBorder("Information"),

			BorderFactory.createEmptyBorder(5, 5, 5, 5)));
			JTextPane text = new JTextPane();
			text.setBorder(null);
			text.setEditable(false);
			text.setPreferredSize(new Dimension(200, 150));
			text.setText(getLotsOfText());
			text.select(0, 0);
			final JScrollPane scrollPane = new JScrollPane(text);
			panel.add(scrollPane);
			scrollPane.getVerticalScrollBar().setValue(0);
			getContentPane().add(panel);

			// Set up the dialog frame
			setTitle("Dialog");
			setModal(true);
			setMaximumSize(new Dimension(400, 300));
			setResizable(true);
			pack();
			setLocationRelativeTo(owner); // Center in frame
			setVisible(true);

			scrollPane.addComponentListener(new ComponentAdapter() {
				@Override
				public void componentResized(ComponentEvent e) {
					try {
						int i=1/0;
						throw new Exception("Size " + scrollPane.getWidth() + ":"
								+ scrollPane.getHeight());
					} catch (Exception exc) {
						exc.printStackTrace();
					}
				}
			});
		}
	}

	private static String getLotsOfText() {
		return "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
				+ "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"
				+ "ccccccccccccccccccccccccccccccccccccccccccccccccccc"
				+ "ddddddddddddddddddddddddddddddddddddddddddddddddddd"
				+ "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee"
				+ "fffffffffffffffffffffffffffffffffffffffffffffffffff"
				+ "ggggggggggggggggggggggggggggggggggggggggggggggggggg"
				+ "hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh";
	}

}
