package test.contrib;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.*;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceOfficeBlue2007LookAndFeel;

public class FileChooser {

	private JFrame mainFrame;
	private JPanel contentPane;
	private UserActions userActionsHandler = new UserActions();
	private JFileChooser fileChooser = new JFileChooser();

	private JFrame getMainFrame() {
		if (mainFrame == null) {
			mainFrame = new JFrame("Manad?er pobierania");
			mainFrame.setSize(new Dimension(640, 480));
			mainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			mainFrame.setContentPane(getContentPane());

			// Creating menu
			JMenuBar menuBar = new JMenuBar();
			JMenu fileMenu = new JMenu("Test");
			JMenu lookAndFeelMenu = new JMenu("Look and feel");
			JMenuItem fileExitMenuItem = new JMenuItem("Fire test",
					KeyEvent.VK_W);
			JMenuItem officeMenuItem = new JMenuItem("Office", KeyEvent.VK_O);

			// Setting action commands and action listener
			fileExitMenuItem.addActionListener(userActionsHandler);
			fileExitMenuItem.setActionCommand(UserActions.ACTION_TEST);
			officeMenuItem.addActionListener(userActionsHandler);
			officeMenuItem.setActionCommand(UserActions.ACTION_OFFICELOOK);

			fileMenu.add(fileExitMenuItem);
			lookAndFeelMenu.add(officeMenuItem);
			menuBar.add(fileMenu);
			menuBar.add(lookAndFeelMenu);

			mainFrame.setJMenuBar(menuBar);
		}
		return mainFrame;
	}

	private JPanel getContentPane() {
		if (contentPane == null) {
			contentPane = new JPanel();
			contentPane.setLayout(new BorderLayout());
		}
		return contentPane;
	}

	// Program start.
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				FileChooser manager = new FileChooser();
				manager.getMainFrame().setVisible(true);
			}
		});
	}

	private class UserActions implements ActionListener {

		public static final String ACTION_OFFICELOOK = "office_look_and_feel";
		public static final String ACTION_TEST = "test_command";

		public void actionPerformed(ActionEvent e) {
			String cmd = e.getActionCommand();
			if (cmd.equals(ACTION_TEST)) {
				test();
			} else if (cmd.equals(ACTION_OFFICELOOK)) {
				try {
					JFrame.setDefaultLookAndFeelDecorated(true);
					JDialog.setDefaultLookAndFeelDecorated(true);
					UIManager
							.setLookAndFeel(new SubstanceOfficeBlue2007LookAndFeel());
					SwingUtilities.updateComponentTreeUI(fileChooser);
					SwingUtilities.updateComponentTreeUI(mainFrame);
				} catch (UnsupportedLookAndFeelException e1) {
					e1.printStackTrace();
				}
			}
		}

		// Test case.
		private void test() {
			int returnVal = fileChooser.showSaveDialog(getMainFrame());
			if (returnVal == JFileChooser.APPROVE_OPTION)
				System.out.println(fileChooser.getSelectedFile().getName());
		}
	}
}
