/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.tabbed.DefaultTabPreviewPainter;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.utils.SubstanceConstants.TabCloseKind;

import test.check.*;

public class TestAnimations extends JFrame {
	public TestAnimations() {
		super(
				"Substance test with very very very very very very very very very very very very very very long title");

		this.setIconImage(SubstanceImageCreator.getBigHexaMarker(6,
				SubstanceLookAndFeel.getTheme()));
		this.setLayout(new BorderLayout());

		JTabbedPane jtp = new JTabbedPane();
		this.add(jtp, BorderLayout.CENTER);

		JPanel checkListPanel = new JPanel();
		checkListPanel.setLayout(new BorderLayout());
		checkListPanel.add(new ListPanel(), BorderLayout.CENTER);
		jtp.addTab("List", Check.getIcon("JListColor16"), checkListPanel);

		JPanel checkTablePanel = new JPanel();
		checkTablePanel.setLayout(new BorderLayout());
		checkTablePanel.add(new TablePanel(), BorderLayout.CENTER);
		jtp.addTab("Table", Check.getIcon("JTableColor16"), checkTablePanel);

		jtp.addTab("Tree", Check.getIcon("JTreeColor16"), new TreePanel());

		// sample menu bar
		JMenuBar jmb = new JMenuBar();

		if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {

			jmb.add(SampleMenuFactory.getThemeMenu());
			jmb.add(SampleMenuFactory.getSkinMenu());
		}
		this.setJMenuBar(jmb);

		TabCloseCallback closeCallbackMain = new TabCloseCallback() {
			public TabCloseKind onAreaClick(JTabbedPane tabbedPane,
					int tabIndex, MouseEvent mouseEvent) {
				if (mouseEvent.getButton() != MouseEvent.BUTTON2)
					return TabCloseKind.NONE;
				if (mouseEvent.isShiftDown()) {
					return TabCloseKind.ALL;
				}
				return TabCloseKind.THIS;
			}

			public TabCloseKind onCloseButtonClick(JTabbedPane tabbedPane,
					int tabIndex, MouseEvent mouseEvent) {
				if (mouseEvent.isAltDown()) {
					return TabCloseKind.ALL_BUT_THIS;
				}
				if (mouseEvent.isShiftDown()) {
					return TabCloseKind.ALL;
				}
				return TabCloseKind.THIS;
			}

			public String getAreaTooltip(JTabbedPane tabbedPane, int tabIndex) {
				return null;
			}

			public String getCloseButtonTooltip(JTabbedPane tabbedPane,
					int tabIndex) {
				StringBuffer result = new StringBuffer();
				result.append("<html><body>");
				result.append("Mouse click closes <b>"
						+ tabbedPane.getTitleAt(tabIndex) + "</b> tab");
				result
						.append("<br><b>Alt</b>-Mouse click closes all tabs but <b>"
								+ tabbedPane.getTitleAt(tabIndex) + "</b> tab");
				result.append("<br><b>Shift</b>-Mouse click closes all tabs");
				result.append("</body></html>");
				return result.toString();
			}
		};

		jtp.putClientProperty(SubstanceLookAndFeel.TABBED_PANE_CLOSE_CALLBACK,
				closeCallbackMain);
		try {
			jtp.putClientProperty(LafWidget.TABBED_PANE_PREVIEW_PAINTER,
					new DefaultTabPreviewPainter());
		} catch (Throwable e) {
		}

	}

	public static void main(String[] args) {
		boolean hasLafSpecified = false;
		try {
			hasLafSpecified = (System.getProperty("swing.defaultlaf") != null);
		} catch (Throwable t) {
			// JNLP sandbox
		}

		try {
			if (!hasLafSpecified) {
				LookAndFeel laf = (LookAndFeel) Class.forName(
						"org.jvnet.substance.SubstanceLookAndFeel")
						.newInstance();
				UIManager.setLookAndFeel(laf);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		UIManager.put(SubstanceLookAndFeel.TABBED_PANE_CLOSE_BUTTONS_PROPERTY,
				Boolean.TRUE);
		TestAnimations c = new TestAnimations();
		c.addComponentListener(new ComponentAdapter() {
			@Override
			public void componentResized(ComponentEvent e) {
				super.componentResized(e);
				((JFrame) e.getComponent()).getRootPane().repaint();
			}
		});
		c.setPreferredSize(new Dimension(400, 300));
		c.setMinimumSize(new Dimension(150, 100));
		c.pack();
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		// center the frame in the physical screen
		c.setLocation((d.width - c.getWidth()) / 2,
				(d.height - c.getHeight()) / 2);

		c.setVisible(true);
		c.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	}
}
