/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.utils.params;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceConstants.ImageWatermarkKind;

/**
 * Reads the properties from JVM flags. This class is <b>for internal use only</b>.
 * 
 * @author Kirill Grouchnikov
 */
public class JvmFlagsParamReader implements ParamReader {
	/**
	 * Retrieves a single parameter from the VM flags.
	 * 
	 * @param parameterName
	 *            Parameter name.
	 * @return Parameter value.
	 */
	protected String getParameter(String parameterName) {
		String paramValue = null;
		try {
			paramValue = System.getProperty(parameterName);
			return paramValue;
		} catch (Exception exc) {
			// probably running in unsecure JNLP - ignore
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getButtonShaperProperty()
	 */
	public String getButtonShaperProperty() {
		return this.getParameter(SubstanceLookAndFeel.BUTTON_SHAPER_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getGradientPainterProperty()
	 */
	public String getGradientPainterProperty() {
		return this
				.getParameter(SubstanceLookAndFeel.GRADIENT_PAINTER_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getTitlePainterProperty()
	 */
	public String getTitlePainterProperty() {
		return this.getParameter(SubstanceLookAndFeel.TITLE_PAINTER_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getBorderPainterProperty()
	 */
	public String getBorderPainterProperty() {
		return this.getParameter(SubstanceLookAndFeel.BORDER_PAINTER_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getThemeProperty()
	 */
	public String getThemeProperty() {
		return this.getParameter(SubstanceLookAndFeel.THEME_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getWatermarkThemeProperty()
	 */
	public String getWatermarkProperty() {
		return this.getParameter(SubstanceLookAndFeel.WATERMARK_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getWatermarkImageProperty()
	 */
	public String getWatermarkImageProperty() {
		return this.getParameter(SubstanceLookAndFeel.WATERMARK_IMAGE_PROPERTY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#toBleedWatermark()
	 */
	public boolean toBleedWatermark() {
		String paramToBleedWatermark = this
				.getParameter(SubstanceLookAndFeel.WATERMARK_TO_BLEED);
		return (paramToBleedWatermark != null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getTraceFileNameProperty()
	 */
	public String getTraceFileNameProperty() {
		return this.getParameter(SubstanceLookAndFeel.TRACE_FILE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#toShowExtraElementProperty()
	 */
	public boolean toShowExtraElementProperty() {
		String paramNoExtraElements = this
				.getParameter(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS);
		return (paramNoExtraElements == null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#toShowHeapStatusPanelProperty()
	 */
	public String toShowHeapStatusPanelProperty() {
		return this.getParameter(SubstanceLookAndFeel.HEAP_STATUS_PANEL);
	}

	/**
	 * Returns the configuration filename.
	 * 
	 * @return Configuration filename.
	 * @see PropertiesFileParamReader
	 * @see SubstanceLookAndFeel#CONFIG_FILE
	 */
	public String getConfigFileName() {
		return this.getParameter(SubstanceLookAndFeel.CONFIG_FILE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#toEnableInvertedThemes()
	 */
	public boolean toEnableInvertedThemes() {
		String paramEnableInvertedThemes = this
				.getParameter(SubstanceLookAndFeel.ENABLE_INVERTED_THEMES);
		return (paramEnableInvertedThemes != null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#toEnableNegatedThemes()
	 */
	public boolean toEnableNegatedThemes() {
		String paramEnableNegatedThemes = this
				.getParameter(SubstanceLookAndFeel.ENABLE_NEGATED_THEMES);
		return (paramEnableNegatedThemes != null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#isDebugUiMode()
	 */
	public boolean isDebugUiMode() {
		String paramDebugUiMode = this
				.getParameter(SubstanceLookAndFeel.DEBUG_UI_MODE);
		return (paramDebugUiMode != null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getWatermarkImageKindProperty()
	 */
	public ImageWatermarkKind getWatermarkImageKindProperty() {
		String paramWatermarkImageKind = this
				.getParameter(SubstanceLookAndFeel.WATERMARK_IMAGE_KIND);
		if (paramWatermarkImageKind == null)
			return null;
		return ImageWatermarkKind.valueOf(paramWatermarkImageKind);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.params.ParamReader#getWatermarkImageOpacityProperty()
	 */
	public Float getWatermarkImageOpacityProperty() {
		String paramWatermarkImageOpacity = this
				.getParameter(SubstanceLookAndFeel.WATERMARK_IMAGE_OPACITY);
		if (paramWatermarkImageOpacity == null)
			return null;
		try {
			return Float.parseFloat(paramWatermarkImageOpacity);
		} catch (NumberFormatException nfe) {
			return null;
		}
	}
}
