/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance;

import java.awt.*;
import java.lang.reflect.Method;
import java.util.List;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.utils.LookUtils;
import org.jvnet.substance.SubstanceTableUI.TableColumnId;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.*;

/**
 * Default renderer for table header cells.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceDefaultTableHeaderCellRenderer extends
		DefaultTableCellRenderer implements UIResource {
	// TODO JDK6 - remove
	private static Method tableGetRowSorterMethod;

	// TODO JDK6 - remove
	private static Method rowSorterGetSortKeysMethod;

	// TODO JDK6 - remove
	private static Method rowSorterSortKeyGetSortOrderMethod;

	// TODO JDK6 - remove
	private static Method rowSorterSortKeyGetColumnMethod;

	static {
		// TODO JDK6 - remove
		if (LookUtils.IS_JAVA_6_OR_LATER) {
			try {
				tableGetRowSorterMethod = JTable.class.getDeclaredMethod(
						"getRowSorter", new Class[0]);
				Class rowSorterClass = Class.forName("javax.swing.RowSorter");
				if (rowSorterClass != null) {
					rowSorterGetSortKeysMethod = rowSorterClass
							.getDeclaredMethod("getSortKeys", new Class[0]);
				}
				Class rowSorterSortKeyClass = Class
						.forName("javax.swing.RowSorter$SortKey");
				if (rowSorterSortKeyClass != null) {
					rowSorterSortKeyGetSortOrderMethod = rowSorterSortKeyClass
							.getDeclaredMethod("getSortOrder", new Class[0]);
					rowSorterSortKeyGetColumnMethod = rowSorterSortKeyClass
							.getDeclaredMethod("getColumn", new Class[0]);
				}
			} catch (Exception exc) {
				tableGetRowSorterMethod = null;
				rowSorterGetSortKeysMethod = null;
				rowSorterSortKeyGetSortOrderMethod = null;
				rowSorterSortKeyGetColumnMethod = null;
			}
		}
	}

	/**
	 * Creates a new cell renderer.
	 */
	public SubstanceDefaultTableHeaderCellRenderer() {
		setHorizontalAlignment(JLabel.CENTER);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable,
	 *      java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		if (table == null) {
			setBorder(DefaultTableCellRenderer.noFocusBorder);
			setValue(value);
			setOpaque(false);
			return this;
		}

		if (table.getTableHeader() == null) {
			return super.getTableCellRendererComponent(table, value,
					isSelected, hasFocus, row, column);
		}

		JTableHeader tableHeader = table.getTableHeader();
		TableHeaderUI tableHeaderUI = tableHeader.getUI();
		if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
			SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI) tableHeaderUI;
			ComponentState state = ui.getColumnState(column);
			ComponentState prevState = ui.getPrevColumnState(column);
			SubstanceTheme theme = SubstanceThemeUtilities.getTheme(tableHeader,
					state);
			Color color = SubstanceCoreUtilities
					.getInterpolatedForegroundColor(tableHeader, column, theme,
							state, prevState, FadeKind.SELECTION,
							FadeKind.ROLLOVER);

			// System.out.println("[column " + column + "] - " +
			// prevState.name() + ":"
			// + state.name() + ":" + color + " from "
			// + theme.getDisplayName());

			super.setForeground(color);
		} else {
			super.setForeground(table.getForeground());
		}

		SubstanceCoreUtilities.applyStripedBackground(table, row, this);

		// fix for issue 319 - using font from the table header
		if (tableHeader.getFont() != null) {
			setFont(tableHeader.getFont());
		} else {
			setFont(table.getFont());
		}

		TableColumnId cellFocusId = new TableColumnId(column);
		FadeState focusState = SubstanceFadeUtilities.getFadeState(table,
				cellFocusId, FadeKind.FOCUS);
		Insets regInsets = SubstanceSizeUtils
				.getTableCellRendererInsets(SubstanceSizeUtils
						.getComponentFontSize(table));
		// if (hasFocus || (focusState != null)) {
		// SubstanceBorder border = new SubstanceBorder(regInsets);
		// if (focusState != null) {
		// border.setAlpha(focusState.getFadePosition() / 10.0f);
		// }
		// this.setBorder(border);
		// } else {
		this.setBorder(new EmptyBorder(regInsets.top, regInsets.left,
				regInsets.bottom, regInsets.right));
		// }

		this.setValue(value);
		this.setOpaque(false);

		this.setEnabled(tableHeader.isEnabled() && table.isEnabled());

		// fix for defect 242 - not showing sort icon under JDK 6.0
		// TODO JDK6

		// the following should be uncommented when Substance moves to JDK 6.0
		// RowSorter rowSorter = table.getRowSorter();
		// if (rowSorter != null) {
		// setHorizontalTextPosition(JLabel.LEADING);
		// java.util.List<? extends RowSorter.SortKey> sortKeys = rowSorter
		// .getSortKeys();
		// Icon sortIcon = null;
		// int arrowWidth = SubstanceSizeUtils.getArrowIconWidth() - 2;
		// int arrowHeight = SubstanceSizeUtils.getArrowIconHeight() - 1;
		// float arrowStrokeWidth = SubstanceSizeUtils.getArrowStrokeWidth();
		// SubstanceTheme theme = null;
		// if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
		// SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI) tableHeaderUI;
		// ComponentState state = ui.getColumnState(column);
		// theme = SubstanceCoreUtilities.getTheme(tableHeader, state,
		// true, true);
		// } else {
		// theme = SubstanceCoreUtilities.getTheme(tableHeader, true);
		// }
		// if (sortKeys.size() > 0
		// && sortKeys.get(0).getColumn() == table
		// .convertColumnIndexToModel(column)) {
		// switch (sortKeys.get(0).getSortOrder()) {
		// case ASCENDING:
		// sortIcon = SubstanceImageCreator.getArrowIcon(arrowWidth,
		// arrowHeight, arrowStrokeWidth,
		// SwingConstants.NORTH, theme);
		// break;
		// case DESCENDING:
		// sortIcon = SubstanceImageCreator.getArrowIcon(arrowWidth,
		// arrowHeight, arrowStrokeWidth,
		// SwingConstants.SOUTH, theme);
		// break;
		// case UNSORTED:
		// sortIcon = null;
		// break;
		// }
		// this.setIcon(sortIcon);
		// }
		// }

		try {
			this.setIcon(null);
			if (LookUtils.IS_JAVA_6_OR_LATER) {
				Object rowSorter = tableGetRowSorterMethod.invoke(table,
						new Object[0]);
				if (rowSorter != null) {
					setHorizontalTextPosition(JLabel.LEADING);
					List sortKeys = (List) rowSorterGetSortKeysMethod.invoke(
							rowSorter, new Object[0]);
					Icon sortIcon = null;
					SubstanceTheme theme = null;
					if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
						SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI) tableHeaderUI;
						ComponentState state = ui.getColumnState(column);
						theme = SubstanceThemeUtilities.getTheme(tableHeader,
								state);
					} else {
						theme = SubstanceThemeUtilities.getTheme(tableHeader);
					}

					Object sortKey0 = sortKeys.get(0);
					int sortColumn = (Integer) rowSorterSortKeyGetColumnMethod
							.invoke(sortKey0, new Object[0]);
					if (sortKeys.size() > 0
							&& sortColumn == table
									.convertColumnIndexToModel(column)) {
						String sortOrderString = rowSorterSortKeyGetSortOrderMethod
								.invoke(sortKey0, new Object[0]).toString();
						if (sortOrderString.indexOf("ASCENDING") >= 0) {
							sortIcon = SubstanceImageCreator.getArrowIcon(
									SubstanceSizeUtils
											.getComponentFontSize(tableHeader),
									SwingConstants.NORTH, theme);
						} else {
							if (sortOrderString.indexOf("DESCENDING") >= 0) {
								sortIcon = SubstanceImageCreator
										.getArrowIcon(
												SubstanceSizeUtils
														.getComponentFontSize(tableHeader),
												SwingConstants.SOUTH, theme);
							}
						}
						this.setIcon(sortIcon);
					}
				}
			}
		} catch (Exception exc) {
			this.setIcon(null);
		}

		return this;
	}

	public static boolean isColumnSorted(JTable table, int columnIndex) {
		// TODO JDK 6 - use proper APIs.
		try {
			if (LookUtils.IS_JAVA_6_OR_LATER) {
				Object rowSorter = tableGetRowSorterMethod.invoke(table,
						new Object[0]);
				if (rowSorter != null) {
					List sortKeys = (List) rowSorterGetSortKeysMethod.invoke(
							rowSorter, new Object[0]);
					Object sortKey0 = sortKeys.get(0);
					int sortColumn = (Integer) rowSorterSortKeyGetColumnMethod
							.invoke(sortKey0, new Object[0]);
					if (sortKeys.size() > 0
							&& sortColumn == table
									.convertColumnIndexToModel(columnIndex)) {
						String sortOrderString = rowSorterSortKeyGetSortOrderMethod
								.invoke(sortKey0, new Object[0]).toString();
						if (sortOrderString.indexOf("ASCENDING") >= 0) {
							return true;
						} else {
							return true;
						}
					}
				}
			}
			return false;
		} catch (Exception exc) {
			return false;
		}

	}
}
