/* MTRPJ0.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mmtrpj0_(ncofmx, ndimen, ncoeff, epsi3d, crvlgd, ycvmax, 
	epstrc, ncfnew)
integer *ncofmx, *ndimen, *ncoeff;
doublereal *epsi3d, *crvlgd, *ycvmax, *epstrc;
integer *ncfnew;
{
    /* System generated locals */
    integer crvlgd_dim1, crvlgd_offset, i__1, i__2;
    doublereal d__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer ncut, i__;
    static doublereal bidon, error;
    static integer nd;
    extern doublereal mzsnorm_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        Baisse le degre d' une courbe definie sur (-1,1) au sens de */
/*        Legendre a une precision donnee. */

/*     MOTS CLES : */
/*     ----------- */
/*        LEGENDRE,POLYGONE,TRONCONNAGE,COURBE,LISSAGE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NCOFMX : Nbre maxi de coeff. de la courbe (dimensionnement). */
/*        NDIMEN   : Dimension de l' espace. */
/*        NCOEFF : Le degre +1 du polynome. */
/*        EPSI3D  : La precision demandee pour l' approximation. */
/*        CRVLGD : La courbe dont on veut baisser le degre. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        EPSTRC : La precision de l' approximation. */
/*        NCFNEW : Le degre +1 du polynome resultat. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/* 17-05-1991 : RBD ; Si le degre n'est pas baisse, l'erreur est nulle */
/* 12-12-1989 : RBD ; Creation. */
/* > */
/* ***********************************************************************
 */


/* ------- Degre minimum pouvant etre atteint : Arret a 1 (RBD) --------- 
*/

    /* Parameter adjustments */
    --ycvmax;
    crvlgd_dim1 = *ncofmx;
    crvlgd_offset = crvlgd_dim1 + 1;
    crvlgd -= crvlgd_offset;

    /* Function Body */
    *ncfnew = 1;
/* ------------------- Init pour calcul d' erreur ----------------------- 
*/
    i__1 = *ndimen;
    for (i__ = 1; i__ <= i__1; ++i__) {
	ycvmax[i__] = 0.;
/* L100: */
    }
    *epstrc = 0.;
    error = 0.;

/*   Coupure des coefficients. */

    ncut = 2;
/* ------ Boucle sur la serie de Legendre :NCOEFF --> 2 (RBD) ----------- 
*/
    i__1 = ncut;
    for (i__ = *ncoeff; i__ >= i__1; --i__) {
/*   Facteur de renormalisation. */
	bidon = ((i__ - 1) * 2. + 1.) / 2.;
	bidon = sqrt(bidon);
	i__2 = *ndimen;
	for (nd = 1; nd <= i__2; ++nd) {
	    ycvmax[nd] += (d__1 = crvlgd[i__ + nd * crvlgd_dim1], abs(d__1)) *
		     bidon;
/* L310: */
	}
/*   On arrete de couper si la norme devient trop grande. */
	error = mzsnorm_(ndimen, &ycvmax[1]);
	if (error > *epsi3d) {
	    *ncfnew = i__;
	    goto L9999;
	}

/* --- Erreur max cumulee lorsque le I-eme coeff est ote. */

	*epstrc = error;

/* L300: */
    }

/* --------------------------------- Fin -------------------------------- 
*/

L9999:
    return 0;
} /* mmtrpj0_ */

