/* MCHOLE.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"


/* Subroutine */ 
#ifdef WNT
__declspec( dllexport ) 
#endif
     int mmchole_(mxcoef, dimens, amatri, aposit, posuiv, chomat, 
	iercod)

integer *mxcoef, *dimens;
doublereal *amatri;
integer *aposit, *posuiv;
doublereal *chomat;
integer *iercod;
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    doublereal d__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static logical ldbg;
    static integer kmin, i__, j, k;
    static doublereal somme;
    static integer ptini, ptcou;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ----------                                                  T */
/*     Effectue la decomposition de choleski de la matrice A en S.S */
/*     Calcul la matrice triangulaire inferieure S. */

/*     MOTS CLES : */
/*     ----------- */
/*     RESOLUTION, MFACTORISATION, MATRICE_PROFILE, CHOLESKI */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     MXCOEF : Nombres maximale de termes dans le profile du hessien */
/*     DIMENS : Dimension du probleme */
/*     AMATRI(MXCOEF) : Coefficients du profil de la matrice */
/*        APOSIT(1,*) : Distance diagonnale-extrimite gauche de la ligne 
*/
/*        APOSIT(2,*) : Position des termes diagonnaux dans HESSIE */
/*     POSUIV(MXCOEF): premiere ligne inferieure non hors profil */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*      CHOMAT(MXCOEF) : Matrice triangulaire inferieure qui conserve */
/*                       le profil de AMATRI. */
/*      IERCOD : code d'erreur */
/*               = 0 : ok */
/*               = 1 : Matrice non definie positive */

/*     COMMONS UTILISES : */
/*     ------------------ */

/*      .Neant. */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     NIVEAU DE DEBUG = 4 */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     14-02-1994: PMN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */



/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    --chomat;
    --posuiv;
    --amatri;
    aposit -= 3;

    /* Function Body */
    ldbg = mnfndeb_() >= 4;
    if (ldbg) {
	mgenmsg_("MMCHOLE", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

    i__1 = *dimens;
    for (j = 1; j <= i__1; ++j) {

	ptini = aposit[(j << 1) + 2];

	somme = 0.;
	i__2 = ptini - 1;
	for (k = ptini - aposit[(j << 1) + 1]; k <= i__2; ++k) {
/* Computing 2nd power */
	    d__1 = chomat[k];
	    somme += d__1 * d__1;
	}

	if (amatri[ptini] - somme < 1e-32) {
	    goto L9101;
	}
	chomat[ptini] = sqrt(amatri[ptini] - somme);

	ptcou = ptini;

	while(posuiv[ptcou] > 0) {

	    i__ = posuiv[ptcou];
	    ptcou = aposit[(i__ << 1) + 2] - (i__ - j);

/*           Calcul la somme de S  .S   pour k =1 a j-1 */
/*                               ik  jk */
	    somme = 0.;
/* Computing MAX */
	    i__2 = i__ - aposit[(i__ << 1) + 1], i__3 = j - aposit[(j << 1) + 
		    1];
	    kmin = max(i__2,i__3);
	    i__2 = j - 1;
	    for (k = kmin; k <= i__2; ++k) {
		somme += chomat[aposit[(i__ << 1) + 2] - (i__ - k)] * chomat[
			aposit[(j << 1) + 2] - (j - k)];
	    }

	    chomat[ptcou] = (amatri[ptcou] - somme) / chomat[ptini];
	}
    }

    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */

L9101:
    *iercod = 1;
    goto L9999;

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:

    maermsg_("MMCHOLE", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMCHOLE", 7L);
    }

 return 0 ;
} /* mmchole_ */

