/* DSPTPT.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Table of constant values */

static integer c__8 = 8;

/* Subroutine */ __MathBase_API int mdsptpt_(ndimen, point1, point2, distan)
integer *ndimen;
doublereal *point1, *point2, *distan;
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer i__;
    static doublereal differ[100];
    static integer  ier;
    long int iofset, j;
    extern /* Subroutine */ int mcrdelt_(), mcrrqst_();
    extern doublereal mzsnorm_();


/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        CALCULE LA DISTANCE ENTRE DEUX POINTS */

/*     MOTS CLES : */
/*     ----------- */
/*        DISTANCE,POINT. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NDIMEN: Dimension de l' espace. */
/*        POINT1: Tableau des coordonnees du 1er point. */
/*        POINT2: Tableau des coordonnees du 2eme point. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        DISTAN: Distance des 2 points. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     21-07-94 : PMN ; La valeur seuil pour alloc passe de 3 a 100 */
/*     15-07-93 : PMN ; Protection des points... */
/*     08-09-90 : DHU ; Utilisation de MZSNORM */
/*     18-07-88 : RBD ; AJOUT D' UN EN TETE STANDARD */
/*     ??-??-?? : XXX ; CREATION */
/* > */
/* ********************************************************************** 
*/


/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    --point2;
    --point1;

    /* Function Body */
    iofset = 0;
    ier = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

    if (*ndimen > 100) {
	mcrrqst_(&c__8, ndimen, differ, &iofset, &ier);
    }

/* --- Si l'allocation est refuse, on applique la methode trivial */

    if (ier > 0) {

	*distan = 0.;
	i__1 = *ndimen;
	for (i__ = 1; i__ <= i__1; ++i__) {
/* Computing 2nd power */
	    d__1 = point1[i__] - point2[i__];
	    *distan += d__1 * d__1;
	}
	*distan = sqrt(*distan);

/* --- Sinon on utilise MZSNORM pour minimiser les risques d'overflow 
*/

    } else {
	i__1 = *ndimen;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    j=iofset + i__ - 1;
	    differ[j] = point2[i__] - point1[i__];
	}

	*distan = mzsnorm_(ndimen, &differ[iofset]);

    }

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

/* --- Desallocation dynamique */

    if (iofset != 0) {
	mcrdelt_(&c__8, ndimen, differ, &iofset, &ier);
    }

 return 0 ;
} /* mdsptpt_ */

