//#74 rln 10.03.99 S4135: new parameters, values and default values
//    gka 10.04.99 S4136: eliminate parameter 'lastpreci'
//S4181 pdn 23.04.99: adding new parameter handling writing of elementary surfaces
#include <Interface_Static.hxx>
#include <MoniTool_MsgFile.hxx>
//tatouage de la librairie
#include <Precision.hxx>
#include <stdio.h>


static int deja = 0;

void  Interface_Static::Standards ()
{
  if (deja) return;  deja = 1;

//   read precision
  //#74 rln 10.03.99 S4135: new values and default value
  Interface_Static::Init ("XSTEP","read.precision.mode",'e',"");
  Interface_Static::Init ("XSTEP","read.precision.mode",'&',"ematch 0");
  Interface_Static::Init ("XSTEP","read.precision.mode",'&',"eval File");
  Interface_Static::Init ("XSTEP","read.precision.mode",'&',"eval User");
  Interface_Static::SetIVal ("read.precision.mode",0);

  Interface_Static::Init ("XSTEP","read.precision.val",'r',"1.e-03");

  Interface_Static::Init ("XSTEP","read.maxprecision.mode",'e',"");
  Interface_Static::Init ("XSTEP","read.maxprecision.mode",'&',"ematch 0");
  Interface_Static::Init ("XSTEP","read.maxprecision.mode",'&',"eval Preferred");
  Interface_Static::Init ("XSTEP","read.maxprecision.mode",'&',"eval Forced");
  Interface_Static::SetIVal ("read.maxprecision.mode",0);

  Interface_Static::Init ("XSTEP","read.maxprecision.val",'r',"1.");

//   encode regularity
//  negatif ou nul : ne rien faire. positif : on y va
  Interface_Static::Init ("XSTEP","read.encoderegularity.angle",'r',"0.01");

//   compute surface curves
//  0 : par defaut. 2 : ne garder que le 2D. 3 : ne garder que le 3D
  //gka S4054
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", 'e',"");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"ematch -3");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval 3DUse_Forced");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval 2DUse_Forced");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval ?");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval Default");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval ?");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval 2DUse_Preferred");
  Interface_Static::Init("XSTEP"  ,"read.surfacecurve.mode", '&',"eval 3DUse_Preferred");
  Interface_Static::SetIVal ("read.surfacecurve.mode",0);

//   write precision
  Interface_Static::Init ("XSTEP","write.precision.mode",'e',"");
  Interface_Static::Init ("XSTEP","write.precision.mode",'&',"ematch -1");
  Interface_Static::Init ("XSTEP","write.precision.mode",'&',"eval Min");
  Interface_Static::Init ("XSTEP","write.precision.mode",'&',"eval Average");
  Interface_Static::Init ("XSTEP","write.precision.mode",'&',"eval Max");
  Interface_Static::Init ("XSTEP","write.precision.mode",'&',"eval User");
  Interface_Static::SetIVal ("write.precision.mode",0);

  Interface_Static::Init ("XSTEP","write.precision.val",'r',"1.e-03");

  // Write surface curves
  // 0: write (defaut), 1: do not write, 2: write except for analytical surfaces
  Interface_Static::Init("XSTEP"  ,"write.surfacecurve.mode", 'e',"");
  Interface_Static::Init("XSTEP"  ,"write.surfacecurve.mode", '&',"ematch 0");
  Interface_Static::Init("XSTEP"  ,"write.surfacecurve.mode", '&',"eval Off");
  Interface_Static::Init("XSTEP"  ,"write.surfacecurve.mode", '&',"eval On");
//  Interface_Static::Init("XSTEP"  ,"write.surfacecurve.mode", '&',"eval NoAnalytic");
  Interface_Static::SetIVal ("write.surfacecurve.mode",1);

//  lastpreci : pour recuperer la derniere valeur codee (cf XSControl)
//    (0 pour dire : pas codee)
//:S4136  Interface_Static::Init("std"    ,"lastpreci", 'r',"0.");


//  ****  MESSAGERIE DE BASE  ****

//  Chargement "manuel" au cas ou les fichiers, env, etc sont KO

  MoniTool_MsgFile::AddMsg ("XSTEP_1","Beginning of IGES file memory loading.");
  MoniTool_MsgFile::AddMsg ("XSTEP_2","File opening error");
  MoniTool_MsgFile::AddMsg ("XSTEP_3","Reason : No such file or directory");
  MoniTool_MsgFile::AddMsg ("XSTEP_4","Reason : Not enough space");
  MoniTool_MsgFile::AddMsg ("XSTEP_5","Reason : Permission denied");
  MoniTool_MsgFile::AddMsg ("XSTEP_6","Reason : Too many open files");
  MoniTool_MsgFile::AddMsg ("XSTEP_7","Reason : Undetermined");
  MoniTool_MsgFile::AddMsg ("XSTEP_8","End of loading IGES file to memory (Elapsed time : %s).");

  MoniTool_MsgFile::AddMsg ("XSTEP_11","Internal error during the file header reading. The process continues");
  MoniTool_MsgFile::AddMsg ("XSTEP_13","Internal error during the reading of the entity %d");
  MoniTool_MsgFile::AddMsg ("XSTEP_14","Internal error during the reading of the entity %d (parameter %d)");
  MoniTool_MsgFile::AddMsg ("XSTEP_15","Total number of loaded entities : %d.");
  MoniTool_MsgFile::AddMsg ("XSTEP_16","Beginning of the model loading");
  MoniTool_MsgFile::AddMsg ("XSTEP_17","End of the model loading");
  MoniTool_MsgFile::AddMsg ("XSTEP_21","Number of ignored Null Entities : %d");
  MoniTool_MsgFile::AddMsg ("XSTEP_22","Entity %s : unknown");
  MoniTool_MsgFile::AddMsg ("XSTEP_23","Entity %s, Type %s : recovered");
  MoniTool_MsgFile::AddMsg ("XSTEP_24","Report : %d unknown entities");
  MoniTool_MsgFile::AddMsg ("XSTEP_25","Number of fail in memory loading : %d.");
  MoniTool_MsgFile::AddMsg ("XSTEP_26","Number of warning in memory loading : %d.");

//  Chargement du vrai fichier langue
  MoniTool_MsgFile::LoadFromEnv ("CSF_XSMessage","XSTEP");
}
