#include <BRepGProp_Domain.ixx>
#include <TopoDS.hxx>

BRepGProp_Domain::BRepGProp_Domain () {}

BRepGProp_Domain::BRepGProp_Domain (const TopoDS_Face& F) :
       myExplorer(F.Oriented(TopAbs_FORWARD),TopAbs_EDGE)
{
}

void BRepGProp_Domain::Init(const TopoDS_Face& F) {
  myExplorer.Init(F.Oriented(TopAbs_FORWARD),TopAbs_EDGE);
}

const TopoDS_Edge& BRepGProp_Domain::Value () 
{
  return TopoDS::Edge(myExplorer.Current());
}


void BRepGProp_Domain::Next () {

  // skip INTERNAL and EXTERNAL edges

  myExplorer.Next();
  while (myExplorer.More()) {
    TopAbs_Orientation Or = myExplorer.Current().Orientation();
    if ((Or == TopAbs_FORWARD) || (Or == TopAbs_REVERSED)) return;
    myExplorer.Next();
  }
}
