// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_GaussSingleIntegration_HeaderFile
#define _math_GaussSingleIntegration_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_Function;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the integration of a function of a single variable <br>
//! between the parameter bounds Lower and Upper. <br>
//!  Warning: Order must be inferior or equal to 61. <br>
class math_GaussSingleIntegration  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT math_GaussSingleIntegration();


//! The Gauss-Legendre integration with N = Order points of integration, <br>
//! is done on the function F between the bounds Lower and Upper. <br>
Standard_EXPORT math_GaussSingleIntegration(math_Function& F,const Standard_Real Lower,const Standard_Real Upper,const Standard_Integer Order);


//! The Gauss-Legendre integration with N = Order points of integration  and <br>
//! given tolerance = Tol is done on the function F between the bounds <br>
//! Lower and Upper. <br>
Standard_EXPORT math_GaussSingleIntegration(math_Function& F,const Standard_Real Lower,const Standard_Real Upper,const Standard_Integer Order,const Standard_Real Tol);
//! returns True if all has been correctly done. <br>
  Standard_Boolean IsDone() const;
//! returns the value of the integral. <br>
  Standard_Real Value() const;

//! Prints information on the current state of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//!  perfoms  actual  computation <br>
Standard_EXPORT   void Perform(math_Function& F,const Standard_Real Lower,const Standard_Real Upper,const Standard_Integer Order) ;


 // Fields PRIVATE
 //
Standard_Real Val;
Standard_Boolean Done;


};


#include <math_GaussSingleIntegration.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
