// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gp_Vec_HeaderFile
#define _gp_Vec_HeaderFile

#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class Standard_DomainError;
class Standard_OutOfRange;
class gp_VectorWithNullMagnitude;
class gp_Dir;
class gp_XYZ;
class gp_Pnt;
class gp_Ax1;
class gp_Ax2;
class gp_Trsf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& gp_Vec_Type_();


//!  Defines a non-persistent vector in 3D space. <br>
class gp_Vec  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 
//! Creates an indefinite vector. <br>
gp_Vec();
//! Creates a unitary vector from a direction V. <br>
gp_Vec(const gp_Dir& V);
//! Creates a vector with a triplet of coordinates. <br>
gp_Vec(const gp_XYZ& Coord);
//! Creates a point with its three cartesian coordinates. <br>
gp_Vec(const Standard_Real Xv,const Standard_Real Yv,const Standard_Real Zv);

//!  Creates a vector from two points. The length of the vector <br>
//!  is the distance between P1 and P2 <br>
gp_Vec(const gp_Pnt& P1,const gp_Pnt& P2);
//! Changes the coordinate of range Index <br>
//!  Index = 1 => X is modified <br>
//!  Index = 2 => Y is modified <br>
//!  Index = 3 => Z is modified <br>//! Raised if Index != {1, 2, 3}. <br>
  void SetCoord(const Standard_Integer Index,const Standard_Real Xi) ;
//! For this vector, assigns <br>
//! -   the values Xv, Yv and Zv to its three coordinates. <br>
  void SetCoord(const Standard_Real Xv,const Standard_Real Yv,const Standard_Real Zv) ;
//! Assigns the given value to the X coordinate of this vector. <br>
  void SetX(const Standard_Real X) ;
//! Assigns the given value to the X coordinate of this vector. <br>
  void SetY(const Standard_Real Y) ;
//! Assigns the given value to the X coordinate of this vector. <br>
  void SetZ(const Standard_Real Z) ;
//! Assigns the three coordinates of Coord to this vector. <br>
  void SetXYZ(const gp_XYZ& Coord) ;

//!  Returns the coordinate of range Index : <br>
//!  Index = 1 => X is returned <br>
//!  Index = 2 => Y is returned <br>
//!  Index = 3 => Z is returned <br>//! Raised if Index != {1, 2, 3}. <br>
  Standard_Real Coord(const Standard_Integer Index) const;
//! For this vector returns its three coordinates Xv, Yv, and Zvinline <br>
  void Coord(Standard_Real& Xv,Standard_Real& Yv,Standard_Real& Zv) const;
//! For this vector, returns its X coordinate. <br>
  Standard_Real X() const;
//! For this vector, returns its Y coordinate. <br>
  Standard_Real Y() const;
//! For this vector, returns its Z  coordinate. <br>
  Standard_Real Z() const;
//!    For this vector, returns <br>
//! -   its three coordinates as a number triple <br>
 const gp_XYZ& XYZ() const;


//!  Returns True if the two vectors have the same magnitude value <br>
//!  and the same direction. The precision values are LinearTolerance <br>
//!  for the magnitude and AngularTolerance for the direction. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const gp_Vec& Other,const Standard_Real LinearTolerance,const Standard_Real AngularTolerance) const;

//!  Returns True if abs(<me>.Angle(Other) - PI/2.) <= AngularTolerance <br>
//!   Raises VectorWithNullMagnitude if <me>.Magnitude() <= Resolution or <br>
//!  Other.Magnitude() <= Resolution from gp <br>
  Standard_Boolean IsNormal(const gp_Vec& Other,const Standard_Real AngularTolerance) const;

//!  Returns True if PI - <me>.Angle(Other) <= AngularTolerance <br>
//!  Raises VectorWithNullMagnitude if <me>.Magnitude() <= Resolution or <br>
//!  Other.Magnitude() <= Resolution from gp <br>
  Standard_Boolean IsOpposite(const gp_Vec& Other,const Standard_Real AngularTolerance) const;

//!  Returns True if Angle(<me>, Other) <= AngularTolerance or <br>
//!  PI - Angle(<me>, Other) <= AngularTolerance <br>
//!  This definition means that two parallel vectors cannot define <br>
//!  a plane but two vectors with opposite directions are considered <br>
//!  as parallel. Raises VectorWithNullMagnitude if <me>.Magnitude() <= Resolution or <br>
//!  Other.Magnitude() <= Resolution from gp <br>
  Standard_Boolean IsParallel(const gp_Vec& Other,const Standard_Real AngularTolerance) const;

//!  Computes the angular value between <me> and <Other> <br>
//!  Returns the angle value between 0 and PI in radian. <br>
//!    Raises VectorWithNullMagnitude if <me>.Magnitude() <= Resolution from gp or <br>
//!  Other.Magnitude() <= Resolution because the angular value is <br>
//!  indefinite if one of the vectors has a null magnitude. <br>
  Standard_Real Angle(const gp_Vec& Other) const;
//! Computes the angle, in radians, between this vector and <br>
//! vector Other. The result is a value between -Pi and Pi. <br>
//! For this, VRef defines the positive sense of rotation: the <br>
//! angular value is positive, if the cross product this ^ Other <br>
//! has the same orientation as VRef relative to the plane <br>
//! defined by the vectors this and Other. Otherwise, the <br>
//! angular value is negative. <br>
//! Exceptions <br>
//! gp_VectorWithNullMagnitude if the magnitude of this <br>
//! vector, the vector Other, or the vector VRef is less than or <br>
//! equal to gp::Resolution(). <br>
//! Standard_DomainError if this vector, the vector Other, <br>
//! and the vector VRef are coplanar, unless this vector and <br>
//! the vector Other are parallel. <br>
  Standard_Real AngleWithRef(const gp_Vec& Other,const gp_Vec& VRef) const;
//! Computes the magnitude of this vector. <br>
  Standard_Real Magnitude() const;
//! Computes the square magnitude of this vector. <br>//! Adds two vectors <br>
  Standard_Real SquareMagnitude() const;

  void Add(const gp_Vec& Other) ;
  void operator +=(const gp_Vec& Other) 
{
  Add(Other);
}

//! Adds two vectors <br>//! Subtracts two vectors <br>
  gp_Vec Added(const gp_Vec& Other) const;
  gp_Vec operator +(const gp_Vec& Other) const
{
  return Added(Other);
}


  void Subtract(const gp_Vec& Right) ;
  void operator -=(const gp_Vec& Right) 
{
  Subtract(Right);
}

//! Subtracts two vectors <br>//! Multiplies a vector by a scalar <br>
  gp_Vec Subtracted(const gp_Vec& Right) const;
  gp_Vec operator -(const gp_Vec& Right) const
{
  return Subtracted(Right);
}


  void Multiply(const Standard_Real Scalar) ;
  void operator *=(const Standard_Real Scalar) 
{
  Multiply(Scalar);
}

//! Multiplies a vector by a scalar <br>//! Divides a vector by a scalar <br>
  gp_Vec Multiplied(const Standard_Real Scalar) const;
  gp_Vec operator *(const Standard_Real Scalar) const
{
  return Multiplied(Scalar);
}


  void Divide(const Standard_Real Scalar) ;
  void operator /=(const Standard_Real Scalar) 
{
  Divide(Scalar);
}

//! Divides a vector by a scalar <br>//! computes the cross product between two vectors <br>
  gp_Vec Divided(const Standard_Real Scalar) const;
  gp_Vec operator /(const Standard_Real Scalar) const
{
  return Divided(Scalar);
}


  void Cross(const gp_Vec& Right) ;
  void operator ^=(const gp_Vec& Right) 
{
  Cross(Right);
}

//! computes the cross product between two vectors <br>
  gp_Vec Crossed(const gp_Vec& Right) const;
  gp_Vec operator ^(const gp_Vec& Right) const
{
  return Crossed(Right);
}


//!  Computes the magnitude of the cross <br>
//!  product between <me> and Right. <br>
//!  Returns || <me> ^ Right || <br>
  Standard_Real CrossMagnitude(const gp_Vec& Right) const;

//!  Computes the square magnitude of <br>
//!  the cross product between <me> and Right. <br>
//!  Returns || <me> ^ Right ||**2 <br>//! Computes the triple vector product. <br>
//!  <me> ^ (V1 ^ V2) <br>
  Standard_Real CrossSquareMagnitude(const gp_Vec& Right) const;

  void CrossCross(const gp_Vec& V1,const gp_Vec& V2) ;
//! Computes the triple vector product. <br>
//!  <me> ^ (V1 ^ V2) <br>
  gp_Vec CrossCrossed(const gp_Vec& V1,const gp_Vec& V2) const;
//! computes the scalar product <br>
  Standard_Real Dot(const gp_Vec& Other) const;
  Standard_Real operator *(const gp_Vec& Other) const
{
  return Dot(Other);
}

//! Computes the triple scalar product <me> * (V1 ^ V2). <br>//! normalizes a vector <br>
//!  Raises an exception if the magnitude of the vector is <br>
//!  lower or equal to Resolution from gp. <br>
  Standard_Real DotCross(const gp_Vec& V1,const gp_Vec& V2) const;

  void Normalize() ;
//! normalizes a vector <br>
//!  Raises an exception if the magnitude of the vector is <br>
//!  lower or equal to Resolution from gp. <br>//! Reverses the direction of a vector <br>
  gp_Vec Normalized() const;

  void Reverse() ;
//! Reverses the direction of a vector <br>
  gp_Vec Reversed() const;
  gp_Vec operator -() const
{
  return Reversed();
}


//!  <me> is setted to the following linear form : <br>
//!  A1 * V1 + A2 * V2 + A3 * V3 + V4 <br>
  void SetLinearForm(const Standard_Real A1,const gp_Vec& V1,const Standard_Real A2,const gp_Vec& V2,const Standard_Real A3,const gp_Vec& V3,const gp_Vec& V4) ;

//!  <me> is setted to the following linear form : <br>
//!  A1 * V1 + A2 * V2 + A3 * V3 <br>
  void SetLinearForm(const Standard_Real A1,const gp_Vec& V1,const Standard_Real A2,const gp_Vec& V2,const Standard_Real A3,const gp_Vec& V3) ;

//!  <me> is setted to the following linear form : <br>
//!  A1 * V1 + A2 * V2 + V3 <br>
  void SetLinearForm(const Standard_Real A1,const gp_Vec& V1,const Standard_Real A2,const gp_Vec& V2,const gp_Vec& V3) ;

//!  <me> is setted to the following linear form : <br>
//!  A1 * V1 + A2 * V2 <br>
  void SetLinearForm(const Standard_Real A1,const gp_Vec& V1,const Standard_Real A2,const gp_Vec& V2) ;

//!  <me> is setted to the following linear form : A1 * V1 + V2 <br>
  void SetLinearForm(const Standard_Real A1,const gp_Vec& V1,const gp_Vec& V2) ;

//!  <me> is setted to the following linear form : V1 + V2 <br>
  void SetLinearForm(const gp_Vec& V1,const gp_Vec& V2) ;


Standard_EXPORT   void Mirror(const gp_Vec& V) ;


//!  Performs the symmetrical transformation of a vector <br>
//!  with respect to the vector V which is the center of <br>
//!  the  symmetry. <br>
Standard_EXPORT   gp_Vec Mirrored(const gp_Vec& V) const;


Standard_EXPORT   void Mirror(const gp_Ax1& A1) ;


//!  Performs the symmetrical transformation of a vector <br>
//!  with respect to an axis placement which is the axis <br>
//!  of the symmetry. <br>
Standard_EXPORT   gp_Vec Mirrored(const gp_Ax1& A1) const;


Standard_EXPORT   void Mirror(const gp_Ax2& A2) ;


//!  Performs the symmetrical transformation of a vector <br>
//!  with respect to a plane. The axis placement A2 locates <br>
//!  the plane of the symmetry : (Location, XDirection, YDirection). <br>
Standard_EXPORT   gp_Vec Mirrored(const gp_Ax2& A2) const;

  void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;

//!  Rotates a vector. A1 is the axis of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
  gp_Vec Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;

  void Scale(const Standard_Real S) ;
//! Scales a vector. S is the scaling value. <br>//! Transforms a vector with the transformation T. <br>
  gp_Vec Scaled(const Standard_Real S) const;


Standard_EXPORT   void Transform(const gp_Trsf& T) ;
//! Transforms a vector with the transformation T. <br>
  gp_Vec Transformed(const gp_Trsf& T) const;
    const gp_XYZ& _CSFDB_Getgp_Veccoord() const { return coord; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& gp_Vec_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_XYZ coord;


};


#include <gp_Vec.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
