// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_UnitsDictionary_HeaderFile
#define _Units_UnitsDictionary_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_UnitsDictionary_HeaderFile
#include <Handle_Units_UnitsDictionary.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Units_QuantitiesSequence_HeaderFile
#include <Handle_Units_QuantitiesSequence.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
class TCollection_HAsciiString;
class Units_QuantitiesSequence;
class TCollection_AsciiString;
class Units_Dimensions;


//! This class creates  a dictionary of all  the units <br>
//!          you want to know. <br>
class Units_UnitsDictionary : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns an empty instance of UnitsDictionary. <br>
Standard_EXPORT Units_UnitsDictionary();

//! Returns a  UnitsDictionary object  which  contains the <br>
//!          sequence  of all   the  units  you want to   consider, <br>
//!          physical quantity by physical quantity. <br>
Standard_EXPORT   void Creates(const Standard_CString afilename) ;
//! Returns   the  head   of   the  sequence  of  physical <br>
//!          quantities. <br>
  Handle_Units_QuantitiesSequence Sequence() const;

//! Returns true if there has been no  modification of the <br>
//!          file Units.dat  since the   creation of the dictionary <br>
//!          object, false otherwise. <br>
Standard_EXPORT   Standard_Boolean UpToDate() const;

//! Returns for <aquantity> the active unit. <br>
Standard_EXPORT   TCollection_AsciiString ActiveUnit(const Standard_CString aquantity) const;
//! Dumps only  the sequence   of  quantities without  the <br>
//!          units  if  <alevel> is  equal  to zero,  and  for each <br>
//!          quantity all the units stored if <alevel>  is equal to <br>
//!          one. <br>
  void Dump(const Standard_Integer alevel) const;
//! Dumps  for a     designated  physical       dimensions <br>
//!          <adimensions> all the previously stored units. <br>
  void Dump(const Handle(Units_Dimensions)& adimensions) const;
//Standard_EXPORT ~Units_UnitsDictionary();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thefilename;
Standard_Integer thetime;
Handle_Units_QuantitiesSequence thequantitiessequence;


};


#include <Units_UnitsDictionary.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
