// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeExtend_CompositeSurface_HeaderFile
#define _ShapeExtend_CompositeSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeExtend_CompositeSurface_HeaderFile
#include <Handle_ShapeExtend_CompositeSurface.hxx>
#endif

#ifndef _Handle_TColGeom_HArray2OfSurface_HeaderFile
#include <Handle_TColGeom_HArray2OfSurface.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Geom_Surface_HeaderFile
#include <Geom_Surface.hxx>
#endif
#ifndef _ShapeExtend_Parametrisation_HeaderFile
#include <ShapeExtend_Parametrisation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class TColGeom_HArray2OfSurface;
class TColStd_HArray1OfReal;
class TColStd_Array1OfReal;
class Geom_Surface;
class gp_Pnt2d;
class gp_Trsf2d;
class gp_Trsf;
class Geom_Geometry;
class Geom_Curve;
class gp_Pnt;
class gp_Vec;


//! Composite surface is represented by a grid of surfaces <br>
//!          (patches) connected geometrically. Patches may have different <br>
//!          parametrisation ranges, but they should be parametrised in <br>
//!          the same manner so that parameter of each patch (u,v) can be converted <br>
//!          to global parameter on the whole surface (U,V) with help of linear <br>
//!          transformation: <br>
class ShapeExtend_CompositeSurface : public Geom_Surface {

public:
 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT ShapeExtend_CompositeSurface();

//! Initializes by a grid of surfaces (calls Init()). <br>
Standard_EXPORT ShapeExtend_CompositeSurface(const Handle(TColGeom_HArray2OfSurface)& GridSurf,const ShapeExtend_Parametrisation param = ShapeExtend_Natural);

//! Initializes by a grid of surfaces (calls Init()). <br>
Standard_EXPORT ShapeExtend_CompositeSurface(const Handle(TColGeom_HArray2OfSurface)& GridSurf,const TColStd_Array1OfReal& UJoints,const TColStd_Array1OfReal& VJoints);

//! Initializes by a grid of surfaces. <br>
//!          All the Surfaces of the grid must have geometrical <br>
//!          connectivity as stated above. <br>
//!          If geometrical connectivity is not satisfied, method <br>
//!          returns False. <br>
//!          However, class is initialized even in that case. <br>
Standard_EXPORT   Standard_Boolean Init(const Handle(TColGeom_HArray2OfSurface)& GridSurf,const ShapeExtend_Parametrisation param = ShapeExtend_Natural) ;

//! Initializes by a grid of surfaces with given global <br>
//!          parametrisation defined by UJoints and VJoints arrays, <br>
//!          each having langth equal to number of patches in corresponding <br>
//!          direction + 1. Global joint values should be sorted in <br>
//!          increasing order. <br>
//!          All the Surfaces of the grid must have geometrical <br>
//!          connectivity as stated above. <br>
//!          If geometrical connectivity is not satisfied, method <br>
//!          returns False. <br>
//!          However, class is initialized even in that case. <br>
Standard_EXPORT   Standard_Boolean Init(const Handle(TColGeom_HArray2OfSurface)& GridSurf,const TColStd_Array1OfReal& UJoints,const TColStd_Array1OfReal& VJoints) ;

//! Returns number of patches in U direction. <br>
Standard_EXPORT   Standard_Integer NbUPatches() const;

//! Returns number of patches in V direction. <br>
Standard_EXPORT   Standard_Integer NbVPatches() const;

//! Returns one surface patch <br>
Standard_EXPORT  const Handle_Geom_Surface& Patch(const Standard_Integer i,const Standard_Integer j) const;

//! Returns grid of surfaces <br>
Standard_EXPORT  const Handle_TColGeom_HArray2OfSurface& Patches() const;

//! Returns the array of U values corresponding to joint <br>
//!          points between patches as well as to start and end points, <br>
//!          which define global parametrisation of the surface <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal UJointValues() const;

//! Returns the array of V values corresponding to joint <br>
//!          points between patches as well as to start and end points, <br>
//!          which define global parametrisation of the surface <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal VJointValues() const;

//! Returns i-th joint value in U direction <br>
//!          (1-st is global Umin, (NbUPatches()+1)-th is global Umax <br>
//!          on the composite surface) <br>
Standard_EXPORT   Standard_Real UJointValue(const Standard_Integer i) const;

//! Returns j-th joint value in V direction <br>
//!          (1-st is global Vmin, (NbVPatches()+1)-th is global Vmax <br>
//!          on the composite surface) <br>
Standard_EXPORT   Standard_Real VJointValue(const Standard_Integer j) const;

//! Sets the array of U values corresponding to joint <br>
//!          points, which define global parametrisation of the surface. <br>
//!          Number of values in array should be equal to NbUPatches()+1. <br>
//!          All the values should be sorted in increasing order. <br>
//!          If this is not satisfied, does nothing and returns False. <br>
Standard_EXPORT   Standard_Boolean SetUJointValues(const TColStd_Array1OfReal& UJoints) ;

//! Sets the array of V values corresponding to joint <br>
//!          points, which define global parametrisation of the surface <br>
//!          Number of values in array should be equal to NbVPatches()+1. <br>
//!          All the values should be sorted in increasing order. <br>
//!          If this is not satisfied, does nothing and returns False. <br>
Standard_EXPORT   Standard_Boolean SetVJointValues(const TColStd_Array1OfReal& VJoints) ;

//! Changes starting value for global U parametrisation (all <br>
//!          other joint values are shifted accordingly) <br>
Standard_EXPORT   void SetUFirstValue(const Standard_Real UFirst) ;

//! Changes starting value for global V parametrisation (all <br>
//!          other joint values are shifted accordingly) <br>
Standard_EXPORT   void SetVFirstValue(const Standard_Real VFirst) ;

//! Returns number of col that contains given (global) parameter <br>
Standard_EXPORT   Standard_Integer LocateUParameter(const Standard_Real U) const;

//! Returns number of row that contains given (global) parameter <br>
Standard_EXPORT   Standard_Integer LocateVParameter(const Standard_Real V) const;

//! Returns number of row and col of surface that contains <br>
//!          given point <br>
Standard_EXPORT   void LocateUVPoint(const gp_Pnt2d& pnt,Standard_Integer& i,Standard_Integer& j) const;

//! Returns one surface patch that contains given (global) parameters <br>
Standard_EXPORT  const Handle_Geom_Surface& Patch(const Standard_Real U,const Standard_Real V) const;

//! Returns one surface patch that contains given point <br>
Standard_EXPORT  const Handle_Geom_Surface& Patch(const gp_Pnt2d& pnt) const;

//! Converts local parameter u on patch i,j to global parameter U <br>
Standard_EXPORT   Standard_Real ULocalToGlobal(const Standard_Integer i,const Standard_Integer j,const Standard_Real u) const;

//! Converts local parameter v on patch i,j to global parameter V <br>
Standard_EXPORT   Standard_Real VLocalToGlobal(const Standard_Integer i,const Standard_Integer j,const Standard_Real v) const;

//! Converts local parameters uv on patch i,j to global parameters UV <br>
Standard_EXPORT   gp_Pnt2d LocalToGlobal(const Standard_Integer i,const Standard_Integer j,const gp_Pnt2d& uv) const;

//! Converts global parameter U to local parameter u on patch i,j <br>
Standard_EXPORT   Standard_Real UGlobalToLocal(const Standard_Integer i,const Standard_Integer j,const Standard_Real U) const;

//! Converts global parameter V to local parameter v on patch i,j <br>
Standard_EXPORT   Standard_Real VGlobalToLocal(const Standard_Integer i,const Standard_Integer j,const Standard_Real V) const;

//! Converts global parameters UV to local parameters uv on patch i,j <br>
Standard_EXPORT   gp_Pnt2d GlobalToLocal(const Standard_Integer i,const Standard_Integer j,const gp_Pnt2d& UV) const;

//! Computes transformation operator and uFactor descrinbing affine <br>
//!          transformation required to convert global parameters on composite <br>
//!          surface to local parameters on patch (i,j): <br>
//!          uv = ( uFactor, 1. ) X Trsf * UV; <br>
//!          NOTE: Thus Trsf contains shift and scale by V, scale by U is stored in uFact. <br>
//!          Returns True if transformation is not an identity <br>
Standard_EXPORT   Standard_Boolean GlobalToLocalTransformation(const Standard_Integer i,const Standard_Integer j,Standard_Real& uFact,gp_Trsf2d& Trsf) const;

//! Applies transformation to all the patches <br>
Standard_EXPORT virtual  void Transform(const gp_Trsf& T) ;

//! Returns a copy of the surface <br>
Standard_EXPORT virtual  Handle_Geom_Geometry Copy() const;

//! NOT IMPLEMENTED (does nothing) <br>
Standard_EXPORT virtual  void UReverse() ;

//! Returns U <br>
Standard_EXPORT virtual  Standard_Real UReversedParameter(const Standard_Real U) const;

//! NOT IMPLEMENTED (does nothing) <br>
Standard_EXPORT virtual  void VReverse() ;

//! Returns V <br>
Standard_EXPORT virtual  Standard_Real VReversedParameter(const Standard_Real V) const;

//! Returns the parametric bounds of grid <br>
Standard_EXPORT virtual  void Bounds(Standard_Real& U1,Standard_Real& U2,Standard_Real& V1,Standard_Real& V2) const;

//! Returns True if grid is closed in U direction <br>
//!          (i.e. connected with Precision::Confusion) <br>
Standard_EXPORT virtual  Standard_Boolean IsUClosed() const;

//! Returns True if grid is closed in V direction <br>
//!          (i.e. connected with Precision::Confusion) <br>
Standard_EXPORT virtual  Standard_Boolean IsVClosed() const;

//! Returns False <br>
Standard_EXPORT virtual  Standard_Boolean IsUPeriodic() const;

//! Returns False <br>
Standard_EXPORT virtual  Standard_Boolean IsVPeriodic() const;

//! NOT IMPLEMENTED (returns Null curve) <br>
Standard_EXPORT virtual  Handle_Geom_Curve UIso(const Standard_Real U) const;

//! NOT IMPLEMENTED (returns Null curve) <br>
Standard_EXPORT virtual  Handle_Geom_Curve VIso(const Standard_Real V) const;

//! returns C0 <br>
Standard_EXPORT virtual  GeomAbs_Shape Continuity() const;

//! returns True if N <=0 <br>
Standard_EXPORT virtual  Standard_Boolean IsCNu(const Standard_Integer N) const;

//! returns True if N <=0 <br>
Standard_EXPORT virtual  Standard_Boolean IsCNv(const Standard_Integer N) const;

//! Computes the point of parameter U,V on the grid. <br>
Standard_EXPORT virtual  void D0(const Standard_Real U,const Standard_Real V,gp_Pnt& P) const;

//! Computes the point P and the first derivatives in the <br>
//!          directions U and V at this point. <br>
Standard_EXPORT virtual  void D1(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;

//! Computes the point P, the first and the second derivatives in <br>
//!          the directions U and V at this point. <br>
Standard_EXPORT virtual  void D2(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;

//! Computes the point P, the first,the second and the third <br>
//!          derivatives in the directions U and V at this point. <br>
Standard_EXPORT virtual  void D3(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;

//! Computes the derivative of order Nu in the direction U and Nv <br>
//!          in the direction V at the point P(U, V). <br>
Standard_EXPORT virtual  gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const;

//! Computes the point of parameter pnt on the grid. <br>
Standard_EXPORT   gp_Pnt Value(const gp_Pnt2d& pnt) const;

//! Computes Joint values according to parameter <br>
Standard_EXPORT   void ComputeJointValues(const ShapeExtend_Parametrisation param = ShapeExtend_Natural) ;

//! Checks geometrical connectivity of the patches, including <br>
//!          closedness (sets fields muUClosed and myVClosed) <br>
Standard_EXPORT   Standard_Boolean CheckConnectivity(const Standard_Real prec) ;
//Standard_EXPORT ~ShapeExtend_CompositeSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColGeom_HArray2OfSurface myPatches;
Handle_TColStd_HArray1OfReal myUJointValues;
Handle_TColStd_HArray1OfReal myVJointValues;
Standard_Boolean myUClosed;
Standard_Boolean myVClosed;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
