// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_TraceFile_HeaderFile
#define _Message_TraceFile_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Message_TraceFile_HeaderFile
#include <Handle_Message_TraceFile.hxx>
#endif

#ifndef _Handle_Message_OutFile_HeaderFile
#include <Handle_Message_OutFile.hxx>
#endif
#ifndef _Message_Printer_HeaderFile
#include <Message_Printer.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Message_EndOfMsg_HeaderFile
#include <Message_EndOfMsg.hxx>
#endif
class Message_OutFile;


//! Defines a Printer for output messages onto a file stream or <br>
//!          standard output (cout). <br>
//!         Thus, main output can be specified by this object and echo <br>
//!          file can be specified by inherited functionality. <br>
//!          This class also provides methods to deal with default Trace File. <br>
class Message_TraceFile : public Message_Printer {

public:
 // Methods PUBLIC
 // 

//! Creates a trace file printer with default parameters <br>
//!          (trace level 0, trace and echo file are cout and echo mode <br>
//!          switched off). <br>
Standard_EXPORT Message_TraceFile();

//! Creates a trace file printer with specified trace level and <br>
//!          file named as <filename>. <br>
//!          If <append> is True then existing file will be appended, <br>
//!          if False, it will be rewritten. <br>
//!          If file creation failed, the output file is directed to <br>
//!          <cout>. See also method IsOpen. <br>
Standard_EXPORT Message_TraceFile(const Standard_Integer tracelevel,const Standard_CString filename,const Standard_Boolean append);

//! Creates a printer with specified trace level and already <br>
//!          created output file defined as Message_OutFile. <br>
Standard_EXPORT Message_TraceFile(const Standard_Integer tracelevel,const Handle(Message_OutFile)& file);

//! Returns output file. <br>
Standard_EXPORT   Handle_Message_OutFile OutFile() const;

//! Sets output file. <br>
//!          If the former one was used only by <me>, it is closed. <br>
Standard_EXPORT   void SetOutFile(const Handle(Message_OutFile)& file) ;
//! Returns True if file opening has succeeded, else returns False. <br>
//!          Always True for standard output. <br>
//!          Calls corresponding method of Message_OutFile. <br>
  Standard_Boolean IsOpen() const;
//! Returns the name of open output file. <br>
//!          Returns an empty string if open on standard output. <br>
  Standard_CString FileName() const;
//! Returns OStream of the output file. <br>
//!          Calls corresponding method of Message_OutFile. <br>
virtual  Standard_OStream& Out() const;

//! Sends a string to the output file. <br>
Standard_EXPORT virtual  void OwnSend(const Standard_CString string,const Message_EndOfMsg theEnd = Message_Endl) const;

//! Returns default Trace File. <br>
Standard_EXPORT static  Handle_Message_TraceFile Default() ;

//! Sets default Trace File. <br>
Standard_EXPORT static  void SetDefault(const Handle(Message_TraceFile)& tracefile) ;

//! Creates new Trace File and sets it as default. <br>
Standard_EXPORT static  void SetDefault(const Standard_Integer tracelevel,const Standard_CString filename,const Standard_Boolean append) ;

//! Sets default Trace File as standard output (cout). <br>
Standard_EXPORT static  void SetDefault() ;
//! Sets trace level for default Trace File <br>
static  Standard_Integer DefaultTraceLevel() ;
//! Returns trace level of default Trace File <br>
static  void SetDefaultTraceLevel(const Standard_Integer tracelevel) ;
//! Sets output file of default Trace File <br>
static  Handle_Message_OutFile DefaultOutFile() ;
//! Sets output stream of default Trace File <br>
static  Standard_OStream& DefaultOut() ;

static  void SetDefLevel(const Standard_Integer level) ;

static  Standard_Integer DefLevel() ;

static  Standard_OStream& Def() ;
//Standard_EXPORT ~Message_TraceFile();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Message_OutFile myFile;


};


#include <Message_TraceFile.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
