// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshAlgo_Edge_HeaderFile
#define _MeshAlgo_Edge_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshDS_DegreeOfFreedom_HeaderFile
#include <MeshDS_DegreeOfFreedom.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes the data structure of a Edge. <br>
class MeshAlgo_Edge  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Give the index of first node of the Edge. <br>
Standard_EXPORT   Standard_Integer FirstNode() const;

//! Give the index of Last node of the Edge. <br>
Standard_EXPORT   Standard_Integer LastNode() const;


Standard_EXPORT   MeshDS_DegreeOfFreedom Movability() const;


Standard_EXPORT   void SetMovability(const MeshDS_DegreeOfFreedom canMove) ;


Standard_EXPORT   Standard_Integer Domain() const;

//! For maping the Edges. <br>
//!          Same Edge -> Same HashCode <br>
//!          Different Edges -> Not IsEqual but can have same HashCode <br>
Standard_EXPORT   Standard_Boolean SameOrientation(const MeshAlgo_Edge& Other) const;


Standard_EXPORT   Standard_Integer HashCode(const Standard_Integer Upper) const;


Standard_EXPORT   Standard_Boolean IsEqual(const MeshAlgo_Edge& Other) const;
  Standard_Boolean operator ==(const MeshAlgo_Edge& Other) const
{
  return IsEqual(Other);
}






protected:

 // Methods PROTECTED
 // 

//! Contructs an Edge beetween to vertices. <br>
Standard_EXPORT MeshAlgo_Edge(const Standard_Integer node1,const Standard_Integer node2,const MeshDS_DegreeOfFreedom canMove,const Standard_Integer domain);


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//
inline Standard_Integer HashCode(const MeshAlgo_Edge& me,const Standard_Integer Upper) {
 return me.HashCode(Upper);
}



#endif
