// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_ShareTool_HeaderFile
#define _Interface_ShareTool_HeaderFile

#ifndef _Handle_Interface_HGraph_HeaderFile
#include <Handle_Interface_HGraph.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Interface_HGraph;
class Standard_DomainError;
class Interface_InterfaceError;
class Interface_InterfaceModel;
class Interface_GeneralLib;
class Interface_GTool;
class Interface_Protocol;
class Interface_Graph;
class Interface_EntityIterator;
class Standard_Transient;
class Standard_Type;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Builds the Graph of Dependancies, from the General Service <br>
//!           "Shared" -> builds for each Entity of a Model, the Shared and <br>
//!           Sharing Lists, and gives access to them. <br>
//!           Allows to complete with Implied References (which are not <br>
//!           regarded as Shared Entities, but are nevertheless Referenced), <br>
//!           this can be usefull for Reference Checking <br>
class Interface_ShareTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a ShareTool from a Model and builds all required data, <br>
//!           by calling the General Service Library and Modules <br>
//!           (GeneralLib given as an argument) <br>
Standard_EXPORT Interface_ShareTool(const Handle(Interface_InterfaceModel)& amodel,const Interface_GeneralLib& lib);

//! Same a above, but GeneralLib is detained by a GTool <br>
Standard_EXPORT Interface_ShareTool(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_GTool)& gtool);

//! Same a above, but GeneralLib is defined through a Protocol <br>
//!           Protocol is used to build the working library <br>
Standard_EXPORT Interface_ShareTool(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_Protocol)& protocol);

//! Same as above, but works with the GTool of the Model <br>
Standard_EXPORT Interface_ShareTool(const Handle(Interface_InterfaceModel)& amodel);

//! Creates a ShareTool from an already defined Graph <br>
//!           Remark that the data of the Graph are copied <br>
Standard_EXPORT Interface_ShareTool(const Interface_Graph& agraph);


Standard_EXPORT Interface_ShareTool(const Handle(Interface_HGraph)& ahgraph);

//! Completes the Graph by Adding Implied References. Hence, they <br>
//!           are considered as Sharing References in all the other queries <br>
Standard_EXPORT   void AddImplied(const Handle(Interface_GTool)& gtool) ;

//! Returns the Model used for Creation (directly or for Graph) <br>
Standard_EXPORT   Handle_Interface_InterfaceModel Model() const;

//! Returns the data used by the ShareTool to work <br>
//!           Can then be used directly (read only) <br>
Standard_EXPORT  const Interface_Graph& Graph() const;

//! Returns the Entities which are not Shared (their Sharing List <br>
//!           is empty) in the Model <br>
Standard_EXPORT   Interface_EntityIterator RootEntities() const;

//! Returns True if <ent> is Shared by other Entities in the Model <br>
Standard_EXPORT   Standard_Boolean IsShared(const Handle(Standard_Transient)& ent) const;

//! Returns the List of Entities Shared by a given Entity <ent> <br>
Standard_EXPORT   Interface_EntityIterator Shareds(const Handle(Standard_Transient)& ent) const;

//! Returns the List of Entities Sharing a given Entity <ent> <br>
Standard_EXPORT   Interface_EntityIterator Sharings(const Handle(Standard_Transient)& ent) const;

//! Returns the count of Sharing Entities of an Entity, which <br>
//!           are Kind of a given Type <br>
Standard_EXPORT   Standard_Integer NbTypedSharings(const Handle(Standard_Transient)& ent,const Handle(Standard_Type)& atype) const;

//! Returns the Sharing Entity of an Entity, which is Kind of a <br>
//!           given Type. Allows to access a Sharing Entity of a given type <br>
//!           when there is one and only one (current case) <br>
Standard_EXPORT   Handle_Standard_Transient TypedSharing(const Handle(Standard_Transient)& ent,const Handle(Standard_Type)& atype) const;

//! Returns the complete list of entities shared by <ent> at any <br>
//!           level, including <ent> itself <br>
//!           If <ent> is the Model, considers the concatenation of <br>
//!           AllShared for each root <br>
//!           If <rootlast> is True (D), the list starts with lower level <br>
//!           entities and ends by the root. Else, the root is first and <br>
//!           the lower level entities are at end <br>
Standard_EXPORT   Interface_EntityIterator All(const Handle(Standard_Transient)& ent,const Standard_Boolean rootlast = Standard_True) const;

//! Utility method which Prints the content of an iterator <br>
//!           (by their Numbers) <br>
Standard_EXPORT   void Print(const Interface_EntityIterator& iter,Standard_OStream& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_HGraph theHGraph;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
