// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_Curve_HeaderFile
#define _IntTools_Curve_HeaderFile

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
class Geom_Curve;
class Geom2d_Curve;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class IntTools_Curve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_Curve();


//! Initializes me by a 3d curve <br>
//! and two 2d curves <br>
Standard_EXPORT IntTools_Curve(const Handle(Geom_Curve)& Curve3d,const Handle(Geom2d_Curve)& FirstCurve2d,const Handle(Geom2d_Curve)& SecondCurve2d);


//! Modifier <br>
Standard_EXPORT   void SetCurves(const Handle(Geom_Curve)& Curve3d,const Handle(Geom2d_Curve)& FirstCurve2d,const Handle(Geom2d_Curve)& SecondCurve2d) ;

//! Modifier <br>
  void SetCurve(const Handle(Geom_Curve)& Curve3d) ;

//! Modifier <br>
  void SetFirstCurve2d(const Handle(Geom2d_Curve)& FirstCurve2d) ;

//! Modifier <br>
  void SetSecondCurve2d(const Handle(Geom2d_Curve)& SecondCurve2d) ;

//! Selector <br>
 const Handle_Geom_Curve& Curve() const;

//! Selector <br>
 const Handle_Geom2d_Curve& FirstCurve2d() const;

//! Selector <br>
 const Handle_Geom2d_Curve& SecondCurve2d() const;


//! Returns true if 3d curve is BoundedCurve from Geom <br>
Standard_EXPORT   Standard_Boolean HasBounds() const;


//! Returns boundary parameters <br>
//! and corresponded 3d point. <br>
Standard_EXPORT   void Bounds(Standard_Real& aT1,Standard_Real& aT2,gp_Pnt& aP1,gp_Pnt& aP2) const;


//! Computes 3d point corresponded to parameter aT1 <br>
//! Returns true if given parameter aT1 <br>
//! is inside the boundaries of the curve <br>
Standard_EXPORT   Standard_Boolean D0(Standard_Real& aT1,gp_Pnt& aP1) const;


//! Returns the type of 3d curve <br>
Standard_EXPORT   GeomAbs_CurveType Type() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Curve my3dCurve;
Handle_Geom2d_Curve my2dCurve1;
Handle_Geom2d_Curve my2dCurve2;


};


#include <IntTools_Curve.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
