// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGraph_UniformRectGrid_HeaderFile
#define _IGESGraph_UniformRectGrid_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGraph_UniformRectGrid_HeaderFile
#include <Handle_IGESGraph_UniformRectGrid.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_XY;
class gp_Pnt2d;
class gp_Vec2d;


//! defines IGESUniformRectGrid, Type <406> Form <22> <br>
//!          in package IGESGraph <br>
class IGESGraph_UniformRectGrid : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGraph_UniformRectGrid();

//! This method is used to set the fields of the class <br>
//!           UniformRectGrid <br>
//!     - nbProps      : Number of property values (NP = 9) <br>
//!     - finite       : Finite/Infinite grid flag <br>
//!     - line         : Line/Point grid flag <br>
//!     - weighted     : Weighted/Unweighted grid flag <br>
//!     - aGridPoint   : Point on the grid <br>
//!     - aGridSpacing : Grid spacing <br>
//!     - pointsX      : No. of points/lines in X Direction <br>
//!     - pointsY      : No. of points/lines in Y Direction <br>
Standard_EXPORT   void Init(const Standard_Integer nbProps,const Standard_Integer finite,const Standard_Integer line,const Standard_Integer weighted,const gp_XY& aGridPoint,const gp_XY& aGridSpacing,const Standard_Integer pointsX,const Standard_Integer pointsY) ;

//! returns the number of property values in <me>. <br>
Standard_EXPORT   Standard_Integer NbPropertyValues() const;

//! returns False if <me> is an infinite grid, <br>
//!         True  if <me> is a finite grid. <br>
Standard_EXPORT   Standard_Boolean IsFinite() const;

//! returns False if <me> is a Point grid, <br>
//!         True  if <me> is a Line grid. <br>
Standard_EXPORT   Standard_Boolean IsLine() const;

//! returns False if <me> is a Weighted grid, <br>
//!         True  if <me> is not a Weighted grid. <br>
Standard_EXPORT   Standard_Boolean IsWeighted() const;

//! returns coordinates of lower left corner, <br>
//!                     if <me> is a finite grid, <br>
//!         coordinates of an arbitrary point, <br>
//!                     if <me> is an infinite grid. <br>
Standard_EXPORT   gp_Pnt2d GridPoint() const;

//! returns the grid-spacing in drawing coordinates. <br>
Standard_EXPORT   gp_Vec2d GridSpacing() const;

//! returns the no. of points/lines in X direction <br>
//!  (only applicable if IsFinite() = 1, i.e: a finite grid). <br>
Standard_EXPORT   Standard_Integer NbPointsX() const;

//! returns the no. of points/lines in Y direction <br>
//!  (only applicable if IsFinite() = 1, i.e: a finite grid). <br>
Standard_EXPORT   Standard_Integer NbPointsY() const;
//Standard_EXPORT ~IGESGraph_UniformRectGrid();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theNbPropertyValues;
Standard_Integer isItFinite;
Standard_Integer isItLine;
Standard_Integer isItWeighted;
gp_XY theGridPoint;
gp_XY theGridSpacing;
Standard_Integer theNbPointsX;
Standard_Integer theNbPointsY;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
