// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeTorus_HeaderFile
#define _BRepPrimAPI_MakeTorus_HeaderFile

#ifndef _BRepPrim_Torus_HeaderFile
#include <BRepPrim_Torus.hxx>
#endif
#ifndef _BRepPrimAPI_MakeOneAxis_HeaderFile
#include <BRepPrimAPI_MakeOneAxis.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class Standard_DomainError;
class gp_Ax2;
class BRepPrim_Torus;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build tori or portions of tori. <br>
//! A MakeTorus object provides a framework for: <br>
//! -   defining the construction of a torus, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeTorus  : public BRepPrimAPI_MakeOneAxis {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a torus of radii R1 R2. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const Standard_Real R1,const Standard_Real R2);

//! Make a section of a torus of radii R1 R2. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const Standard_Real R1,const Standard_Real R2,const Standard_Real angle);

//! Make  a torus of  radii R2, R2  with angles on the <br>
//!          small circle. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const Standard_Real R1,const Standard_Real R2,const Standard_Real angle1,const Standard_Real angle2);

//! Make  a torus of  radii R2, R2  with angles on the <br>
//!          small circle. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const Standard_Real R1,const Standard_Real R2,const Standard_Real angle1,const Standard_Real angle2,const Standard_Real angle);

//! Make a torus of radii R1 R2. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2);

//! Make a section of a torus of radii R1 R2. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2,const Standard_Real angle);

//! Make a torus of radii R1 R2. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2,const Standard_Real angle1,const Standard_Real angle2);

//! Make a section of a torus of radii R1 R2. <br>//! For all algorithms The resulting shape is composed of <br>
//!         a lateral toroidal face, <br>
//!         two conical faces (defined  by the equation v = angle1 and <br>
//!      v = angle2) if the sphere is truncated in the v parametric <br>
//!      direction (they may be cylindrical faces in some <br>
//!      particular conditions), and in case of a portion <br>
//!      of torus, two planar faces to close the shape.(in the planes <br>
//!      u = 0 and u = angle). <br>
//! Notes: <br>
//!         The u parameter corresponds to a rotation angle around the Z axis. <br>
//!         The circle whose radius is equal to the minor radius, <br>
//!      located in the plane defined by the X axis and the Z axis, <br>
//!      centered on the X axis, on its positive side, and positioned <br>
//!      at a distance from the origin equal to the major radius, is <br>
//!      the reference circle of the torus. The rotation around an <br>
//!      axis parallel to the Y axis and passing through the center <br>
//!      of the reference circle gives the v parameter on the <br>
//!      reference circle. The X axis gives the origin of the v <br>
//! parameter. Near 0, as v increases, the Z coordinate decreases. <br>
Standard_EXPORT BRepPrimAPI_MakeTorus(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2,const Standard_Real angle1,const Standard_Real angle2,const Standard_Real angle);

//! Returns the algorithm. <br>
Standard_EXPORT   Standard_Address OneAxis() ;

//! Returns the algorithm. <br>
//! <br>
Standard_EXPORT   BRepPrim_Torus& Torus() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepPrim_Torus myTorus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
