// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepClass3d_SClassifier_HeaderFile
#define _BRepClass3d_SClassifier_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
class Standard_DomainError;
class BRepClass3d_SolidExplorer;
class gp_Pnt;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides an algorithm to classify a point in a solid. <br>
class BRepClass3d_SClassifier  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT BRepClass3d_SClassifier();

//! Constructor to classify the point P with the <br>
//!          tolerance Tol on the solid S. <br>
Standard_EXPORT BRepClass3d_SClassifier(BRepClass3d_SolidExplorer& S,const gp_Pnt& P,const Standard_Real Tol);

//! Classify the point P with the <br>
//!          tolerance Tol on the solid S. <br>
//! <br>
Standard_EXPORT   void Perform(BRepClass3d_SolidExplorer& S,const gp_Pnt& P,const Standard_Real Tol) ;

//! Classify an infinite point with the <br>
//!          tolerance Tol on the solid S. <br>
Standard_EXPORT   void PerformInfinitePoint(BRepClass3d_SolidExplorer& S,const Standard_Real Tol) ;

//! Returns True if the classification has been <br>
//!          computed by rejection. <br>
//!          The State is then OUT. <br>
Standard_EXPORT   Standard_Boolean Rejected() const;

//! Returns the result of the classification. <br>
Standard_EXPORT   TopAbs_State State() const;

//! Returns True when the point is a point of a face. <br>
Standard_EXPORT   Standard_Boolean IsOnAFace() const;

//! Returns the face used to determine the <br>
//!          classification. When the state is ON, this is the <br>
//!          face containing the point. <br>
//! <br>
//!          When Rejected() returns True, Face() has no signification. <br>
Standard_EXPORT   TopoDS_Face Face() const;





protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void ForceIn() ;


Standard_EXPORT   void ForceOut() ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Face myFace;
Standard_Integer myState;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
