// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_SolidBuilder_HeaderFile
#define _BOP_SolidBuilder_HeaderFile

#ifndef _BOP_LoopSet_HeaderFile
#include <BOP_LoopSet.hxx>
#endif
#ifndef _BOP_BlockIterator_HeaderFile
#include <BOP_BlockIterator.hxx>
#endif
#ifndef _BOP_BlockBuilder_HeaderFile
#include <BOP_BlockBuilder.hxx>
#endif
#ifndef _BOP_SolidAreaBuilder_HeaderFile
#include <BOP_SolidAreaBuilder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BOP_ShellFaceSet;
class TopoDS_Shell;
class TopoDS_Face;
class BOP_ShapeSet;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!   Construct Solids from a Shell Faces  Set (SFS) <br>
class BOP_SolidBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_SolidBuilder();


//! The constructor that just calls the method <br>
//! InitSolidBuilder() below <br>
Standard_EXPORT BOP_SolidBuilder(BOP_ShellFaceSet& theSFS,const Standard_Boolean theForceClassFlag = Standard_False);


//! Launches the algorithm consisting of four steps <br>
//! 1.  Split the SFS on shells ( BOP_SFSCorrector object) <br>
//! 2.  Make Loops from shells  ( this->MakeLoops() ) <br>
//! 3.  Make Areas from Loops   ( BOP_SolidAreaBuilder object) <br>
//! 4.  Make Solids from Areas  ( see methods below ) <br>
Standard_EXPORT   void InitSolidBuilder(BOP_ShellFaceSet& theSFS,const Standard_Boolean theForceClassFlag) ;


Standard_EXPORT   Standard_Integer InitSolid() ;


Standard_EXPORT   Standard_Boolean MoreSolid() const;


Standard_EXPORT   void NextSolid() ;


Standard_EXPORT   Standard_Integer InitShell() ;


Standard_EXPORT   Standard_Boolean MoreShell() const;


Standard_EXPORT   void NextShell() ;


Standard_EXPORT   Standard_Boolean IsOldShell() const;


Standard_EXPORT   TopoDS_Shell OldShell() const;


Standard_EXPORT   Standard_Integer InitFace() ;


Standard_EXPORT   Standard_Boolean MoreFace() const;


Standard_EXPORT   void NextFace() ;


//! Returns current new face of current new shell. <br>
Standard_EXPORT  const TopoDS_Face& Face() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void MakeLoops(BOP_ShapeSet& theSFS) ;


 // Fields PRIVATE
 //
BOP_LoopSet myLoopSet;
BOP_BlockIterator myBlockIterator;
BOP_BlockBuilder myBlockBuilder;
BOP_SolidAreaBuilder mySolidAreaBuilder;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
