/*
 *   dsperr.c -- DSP Manager error functions
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mwave.h>
#include "dsperr.h"
#include "port_types.h"

LPCTSTR  DspFuncNames[] = { TEXT("DSPMDD_DspAbilities"),        /* 0x40 */
                            TEXT("DSPMDD_DspAllocateSegment"),
                            TEXT("DSPMDD_DspChangeCPF"),
                            TEXT("DSPMDD_DspChangeDMA"),
                            TEXT("DSPMDD_DspChangeModuleState"),
                            TEXT("DSPMDD_DspChangeTaskState"),
                            TEXT("DSPMDD_DspConnectGPC"),
                            TEXT("DSPMDD_DspConnectIPC"),
                            TEXT("DSPMDD_DspConnectITCB"),
                            TEXT("DSPMDD_DspDisconnectIPC"),
                            TEXT("DSPMDD_DspDisconnectGPC"),
                            TEXT("DSPMDD_DspDisconnectITCB"),
                            TEXT("DSPMDD_DspFreeModule"),
                            TEXT("DSPMDD_DspFreeSegment"),
                            TEXT("DSPMDD_DspFreeTask"),
                            TEXT("DSPMDD_DspInit"),
                            TEXT("DSPMDD_DspLabelToAddr"),
                            TEXT("DSPMDD_DspLoadModule"),
                            TEXT("DSPMDD_DspLoadSegment"),
                            TEXT("DSPMDD_DspLoadTask"),
                            TEXT("DSPMDD_DspLockMem"),
                            TEXT("DSPMDD_DspMemTransfer"),
                            TEXT("DSPMDD_DspNameToModuleHandle"),
                            TEXT("DSPMDD_DspNameToSegmentHandle"),
                            TEXT("DSPMDD_DspNameToTaskHandle"),
                            TEXT("DSPMDD_DspQueryDSPInfo"),
                            TEXT("DSPMDD_DspQueryManagerInfo"),
                            TEXT("DSPMDD_DspQueryMiscInfo"),
                            TEXT("DSPMDD_DspQueryModuleInfo"),
                            TEXT("DSPMDD_DspQueryTaskInfo"),
                            TEXT("DSPMDD_DspReset"),
                            TEXT("DSPMDD_DspRun"),
                            TEXT("DSPMDD_DspUnLockMem") };      /* 0x60 */

LPCTSTR  DspUnknownFunc =   TEXT("an UNKNOWN function");


VOID MwBox(LPCTSTR lpscMsg)
{
  MW_SYSLOG_2(TRACE_MANAGER_SPECIFIC,"dsperr::MwBox, lpscMsg %s\n",lpscMsg);
}

LPCTSTR MwFunctionToStr( DWORD dwFunction )
{
    if ((dwFunction < DSPMDD_DspAbilities) ||
        (dwFunction > DSPMDD_DspUnLockMem))
      return DspUnknownFunc;

    else
      return DspFuncNames[(dwFunction - DSPMDD_DspAbilities)];
}

VOID MwExceptionBox( DWORD ExceptionCode, LPCTSTR Location )
{

  MW_SYSLOG_3(TRACE_MANAGER_SPECIFIC,"dsperr::MwExceptionBox ExceptionCode %lx Location %s\n",ExceptionCode,Location);
}
                        

