/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class MutableGenotype
extends Genotype {
    public MutableGenotype(Genotype parent) {
        super(parent.getSampleName(), parent.getAlleles(), parent.getNegLog10PError(), parent.getFilters(), parent.getAttributes(), parent.isPhased());
    }

    public MutableGenotype(String sampleName, Genotype parent) {
        super(sampleName, parent.getAlleles(), parent.getNegLog10PError(), parent.getFilters(), parent.getAttributes(), parent.isPhased());
    }

    public MutableGenotype(String sampleName, List<Allele> alleles, double negLog10PError, Set<String> filters, Map<String, ?> attributes, boolean genotypesArePhased) {
        super(sampleName, alleles, negLog10PError, filters, attributes, genotypesArePhased);
    }

    public MutableGenotype(String sampleName, List<Allele> alleles, double negLog10PError) {
        super(sampleName, alleles, negLog10PError);
    }

    public MutableGenotype(String sampleName, List<Allele> alleles) {
        super(sampleName, alleles);
    }

    public Genotype unmodifiableGenotype() {
        return new Genotype(this.getSampleName(), this.getAlleles(), this.getNegLog10PError(), this.getFilters(), this.getAttributes(), this.isPhased());
    }

    public void setAlleles(List<Allele> alleles) {
        this.alleles = new ArrayList<Allele>(alleles);
        if (alleles == null) {
            throw new IllegalArgumentException("BUG: alleles cannot be null in setAlleles");
        }
        if (alleles.size() == 0) {
            throw new IllegalArgumentException("BUG: alleles cannot be of size 0 in setAlleles");
        }
        int nNoCalls = 0;
        for (Allele allele : alleles) {
            nNoCalls += allele.isNoCall() ? 1 : 0;
        }
        if (nNoCalls > 0 && nNoCalls != alleles.size()) {
            throw new IllegalArgumentException("BUG: alleles include some No Calls and some Calls, an illegal state " + this);
        }
        for (Allele allele : alleles) {
            if (allele != null) continue;
            throw new IllegalArgumentException("BUG: Cannot add a null allele to a genotype");
        }
    }

    public void setPhase(boolean isPhased) {
        this.isPhased = isPhased;
    }

    public void setName(String name) {
        this.commonInfo.setName(name);
    }

    public void addFilter(String filter) {
        this.commonInfo.addFilter(filter);
    }

    public void addFilters(Collection<String> filters) {
        this.commonInfo.addFilters(filters);
    }

    public void clearFilters() {
        this.commonInfo.clearFilters();
    }

    public void setFilters(Collection<String> filters) {
        this.commonInfo.setFilters(filters);
    }

    public void setAttributes(Map<String, ?> map) {
        this.commonInfo.setAttributes(map);
    }

    public void clearAttributes() {
        this.commonInfo.clearAttributes();
    }

    public void putAttribute(String key, Object value) {
        this.commonInfo.putAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.commonInfo.removeAttribute(key);
    }

    public void putAttributes(Map<String, ?> map) {
        this.commonInfo.putAttributes(map);
    }

    public void setNegLog10PError(double negLog10PError) {
        this.commonInfo.setNegLog10PError(negLog10PError);
    }

    public void putAttribute(String key, Object value, boolean allowOverwrites) {
        this.commonInfo.putAttribute(key, value, allowOverwrites);
    }
}

