#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <utils/pubmeddownloader.h>
#include <medicalutils/ebmdata.h>

#include <QDebug>


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->pmid->setText("11497241");
    m_Downloader = new Utils::PubMedDownloader(this);
    connect(m_Downloader, SIGNAL(downloadFinished()), this, SLOT(downloadFinished()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pushButton_clicked()
{
    m_Downloader->setPMID(ui->pmid->text());
    m_Downloader->startDownload();
}

void MainWindow::downloadFinished()
{
    ui->textBrowser->setPlainText(m_Downloader->xmlEncoded());
    MedicalUtils::EbmData data;
    data.setPubMedXml(m_Downloader->xmlEncoded());

    qWarning() << data;

    for(int i=0; i < MedicalUtils::EbmData::ReferencesCount; ++i) {
        qWarning() << i << data.data(i);
    }

}
