# $Id: Vsynteny.pm,v 1.6 2011-06-10 14:16:56 sb23 Exp $

package EnsEMBL::Web::ImageConfig::Vsynteny;

use strict;

use base qw(EnsEMBL::Web::ImageConfig::Vertical);

sub init {
  my $self = shift;

  $self->set_parameters({
    title           => 'Synteny panel',
    label           => 'above',
    band_labels     => 'off',
    image_height    => 500,
    image_width     => 550,
    top_margin      => 20,
    band_links      => 'no',
    main_width      => 30,
    secondary_width => 12,
    padding         => 4,
    spacing         => 20,
    inner_padding   => 140,
    outer_padding   => 20,
  });

  $self->create_menus('synteny');
  $self->add_tracks('synteny', [ 'Vsynteny', 'Videogram', 'Vsynteny', { display => 'normal', renderers => [ 'normal', 'normal' ], colourset => 'ideogram' } ]);
  $self->storable = 0;
}

1;
