# $Id: LDFormats.pm,v 1.6 2011-04-11 10:48:54 ma7 Exp $

package EnsEMBL::Web::Component::Export::LDFormats;

use strict;

use URI::Escape qw(uri_unescape);

use base qw(EnsEMBL::Web::Component::Export);

sub content {
  my $self        = shift;
  my $hub         = $self->hub;
  my $type        = $hub->param('type');
  my $form_action = $hub->url({ pop1 => $hub->param('pop1') }, 1); 
  my $text        = 'Please choose a format for your exported data';
  my $form        = $self->modal_form('export_output_configuration', $form_action->[0], { no_button => 1, method => 'get' });
  my (@list, $params);
  
  $form->add_fieldset;
  
  if ($type) {    
    $form->add_notes({ class => undef, text => 'Your export has been processed successfully. You can download the exported data by following the links below' });
    $form->add_element(type => 'Hidden', name => $_, value => $form_action->[1]->{$_}) for keys %{$form_action->[1]};
    $form->add_button(type => 'Submit', name => 'submit', value => '< Back');
  } else {
    $form->add_notes({ class => undef, text => 'Please choose the output format for your export' });
  }
  
  foreach ($self->get_formats($type)) {    
    my $url   = uri_unescape($_->[1] . ($_->[2] ? ";_format=$_->[2]" : ''));
    my $class = $_->[5] || 'modal_close';
    
    push @list, qq{<a class="$class" href="$url"$_->[3]>$_->[0]</a>$_->[4]};
  }
  
  $form->add_notes({ class => undef, list => \@list });
  
  return '<h2>Export Configuration - Linkage Disequilibrium Data</h2>' . $form->render;
}

sub get_formats {
  my $self = shift;
  my $type = shift;
  my $hub  = $self->hub;
  
  my @formats;

  if ($type eq 'haploview') {
    @formats = (
      [ 'Genotype file',     $hub->param('gen_file'),   '', ' rel="external"', ' [Genotypes in linkage format]' ],
      [ 'Locus information', $hub->param('locus_file'), '', ' rel="external"', ' [Locus information file]' ],
      [ 'Combined file',     $hub->param('tar_file') ]
    );
  } elsif ($type eq 'excel') {
    @formats = (
      [ 'Excel', $hub->param('excel_file') ]
    );
  } else {
    my %params   = %{$hub->referer->{'params'}};
    my $function = $hub->function;
    my %populations;

    foreach (keys %params) {
      if ($_ =~/pop\d+/){
        my $name = $params{$_}->[0];
        $populations{$_} = $name;
      }
    }
    
    my $href = $hub->url({
      type    => 'Export/Output', 
      action  => 'Location', 
      output  => 'ld', 
      %populations
    });
    
    my $excel = $hub->url({
      type     => 'Export',
      action   => 'LDExcelFile',
      function => $function, 
      %populations
    });
    
    my $haploview = $hub->url({
      type     => 'Export',
      action   => 'HaploviewFiles',
      function => $function, 
      %populations
    });
    
    
    @formats = (
      [ 'HTML',  $href, 'HTML', ' rel="external"' ],
      [ 'Text',  $href, 'Text', ' rel="external"' ],
      [ 'Excel', $excel, '', '', '', 'modal_link' ],
      [ 'For upload into Haploview software', $haploview, '', '', ' [<a href="http://www.broad.mit.edu/mpg/haploview/" rel="external">Haploview website</a>]', 'modal_link' ]
    );
  }
  
  return @formats;
}

1;
