/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.Score;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.util.Comparator;
import apollo.util.FeatureAlphabeticalComparator;
import apollo.util.FeatureComparator;
import apollo.util.FeatureInequalityException;
import apollo.util.FeatureList;
import apollo.util.QuickSort;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bdgp.util.VectorUtil;

public class SeqFeatureUtil {
    public static AnnotatedFeatureI getAnnotRoot(AnnotatedFeatureI annotatedFeatureI) {
        if (annotatedFeatureI.isAnnotTop()) {
            return annotatedFeatureI;
        }
        if (annotatedFeatureI.getRefFeature() == null) {
            return null;
        }
        if (annotatedFeatureI.getRefFeature().getAnnotatedFeature() == null) {
            return null;
        }
        return SeqFeatureUtil.getAnnotRoot(annotatedFeatureI.getRefFeature().getAnnotatedFeature());
    }

    public static boolean containsFeature(SeqFeatureI seqFeatureI, SeqFeatureI seqFeatureI2) {
        if (seqFeatureI == seqFeatureI2) {
            return true;
        }
        boolean bl = false;
        int n = seqFeatureI.getNumberOfChildren();
        for (int i = 0; i < n && !bl; ++i) {
            SeqFeatureI seqFeatureI3 = seqFeatureI.getFeatureAt(i);
            bl = SeqFeatureUtil.containsFeature(seqFeatureI3, seqFeatureI2);
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    public static boolean isAminoAcidAlignment(String string) {
        return string.toUpperCase().indexOf("BLASTX") != -1;
    }

    public static boolean isAminoAcidAlignment(SeqFeatureI seqFeatureI) {
        return SeqFeatureUtil.isAminoAcidAlignment(seqFeatureI.getFeatureType());
    }

    public static String guessResidueTypeFromFeatureLength(int n, int n2) {
        float f = Math.abs((float)n2 / (float)n);
        return (double)f > 2.0 ? "AA" : "DNA";
    }

    public static Vector getFeaturesOfClass(SeqFeatureI seqFeatureI, Class clazz, boolean bl) {
        Vector vector = new Vector();
        if (seqFeatureI == null) {
            if (Config.DEBUG) {
                SeqFeatureUtil.debug("DEBUG null feature for SeqFeatureUtil.getFeaturesOfClass");
                new Throwable().printStackTrace();
            }
            return vector;
        }
        SeqFeatureUtil.populateFeaturesOfClass(vector, seqFeatureI, clazz, bl);
        return vector;
    }

    protected static void populateFeaturesOfClass(Vector vector, SeqFeatureI seqFeatureI, Class clazz, boolean bl) {
        if (seqFeatureI == null) {
            if (Config.DEBUG) {
                SeqFeatureUtil.debug("null feature for SeqFeatureUtil.populateFeaturesOfClass");
                new Throwable().printStackTrace();
            }
            return;
        }
        if (clazz.isAssignableFrom(seqFeatureI.getClass())) {
            vector.addElement(seqFeatureI);
            if (!bl) {
                return;
            }
        }
        if (seqFeatureI.canHaveChildren()) {
            FeatureSetI featureSetI = (FeatureSetI)seqFeatureI;
            for (int i = 0; i < featureSetI.getFeatures().size(); ++i) {
                SeqFeatureI seqFeatureI2 = (SeqFeatureI)featureSetI.getFeatures().elementAt(i);
                SeqFeatureUtil.populateFeaturesOfClass(vector, seqFeatureI2, clazz, bl);
            }
        }
    }

    public static Vector getSortedKids(SeqFeatureI seqFeatureI) {
        if (seqFeatureI.getName().equals("SeqFeatureI.NO_NAME")) {
            System.out.println("What the hell is this " + seqFeatureI.getClass().getName() + " of type " + seqFeatureI.getFeatureType() + " with " + seqFeatureI.size() + " features?");
        }
        int n = seqFeatureI.size();
        Vector<SeqFeatureI> vector = new Vector<SeqFeatureI>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(seqFeatureI.getFeatureAt(i));
        }
        SeqFeatureUtil.sort(vector, seqFeatureI.getStrand());
        return vector;
    }

    public static void sort(Vector vector, int n) {
        int n2;
        int n3 = vector.size();
        if (n3 == 0) {
            return;
        }
        int[] nArray = new int[n3];
        Object[] objectArray = new RangeI[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            RangeI rangeI = (RangeI)vector.elementAt(n2);
            nArray[n2] = rangeI.getStart();
            objectArray[n2] = rangeI;
        }
        QuickSort.sort(nArray, objectArray);
        if (n == 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                vector.setElementAt(objectArray[n2], n2);
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                vector.setElementAt(objectArray[n2], n3 - n2 - 1);
            }
        }
    }

    public static boolean equals(CurationSet curationSet, CurationSet curationSet2) {
        return SeqFeatureUtil.equals(curationSet.getResults(), curationSet2.getResults());
    }

    public static boolean equals(SeqFeatureI seqFeatureI, SeqFeatureI seqFeatureI2) {
        if (seqFeatureI instanceof FeatureSetI && seqFeatureI2 instanceof FeatureSetI) {
            return SeqFeatureUtil.equalsFeatures(seqFeatureI, seqFeatureI2) && SeqFeatureUtil.equals((FeatureSetI)seqFeatureI, (FeatureSetI)seqFeatureI2);
        }
        if (seqFeatureI instanceof FeaturePairI && seqFeatureI2 instanceof FeaturePairI) {
            return SeqFeatureUtil.equalsFeatures(seqFeatureI, seqFeatureI2) && SeqFeatureUtil.equals((FeaturePairI)seqFeatureI, (FeaturePairI)seqFeatureI2);
        }
        return SeqFeatureUtil.equalsFeatures(seqFeatureI, seqFeatureI2);
    }

    public static boolean equals(FeaturePairI featurePairI, FeaturePairI featurePairI2) {
        if (!SeqFeatureUtil.equals(featurePairI.getQueryFeature(), featurePairI2.getQueryFeature())) {
            throw new FeatureInequalityException("Query features don't match", featurePairI, featurePairI2);
        }
        if (!SeqFeatureUtil.equals(featurePairI.getHitFeature(), featurePairI2.getHitFeature())) {
            throw new FeatureInequalityException("Hit features don't match", featurePairI, featurePairI2);
        }
        return true;
    }

    public static boolean equals(FeatureSetI featureSetI, FeatureSetI featureSetI2) {
        if (featureSetI.getFeatures().size() != featureSetI2.getFeatures().size()) {
            throw new FeatureInequalityException("Different feature counts", featureSetI, featureSetI2);
        }
        Vector vector = VectorUtil.sort((Vector)featureSetI.getFeatures(), (org.bdgp.util.Comparator)new FeatureComparator());
        Vector vector2 = VectorUtil.sort((Vector)featureSetI2.getFeatures(), (org.bdgp.util.Comparator)new FeatureComparator());
        for (int i = 0; i < vector.size(); ++i) {
            SeqFeatureI seqFeatureI;
            SeqFeatureI seqFeatureI2 = (SeqFeatureI)vector.elementAt(i);
            if (SeqFeatureUtil.equals(seqFeatureI2, seqFeatureI = (SeqFeatureI)vector2.elementAt(i))) continue;
            throw new FeatureInequalityException("Features don't match", featureSetI, featureSetI2);
        }
        return true;
    }

    public static boolean equalsFeatures(SeqFeatureI seqFeatureI, SeqFeatureI seqFeatureI2) {
        if (!SeqFeatureUtil.strcmp(seqFeatureI.getId(), seqFeatureI2.getId())) {
            throw new FeatureInequalityException("Mismatched ids", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.strcmp(seqFeatureI.getName(), seqFeatureI2.getName())) {
            throw new FeatureInequalityException("Mismatched names", seqFeatureI, seqFeatureI2);
        }
        if (seqFeatureI.getStart() != seqFeatureI2.getStart()) {
            throw new FeatureInequalityException("Mismatched starts", seqFeatureI, seqFeatureI2);
        }
        if (seqFeatureI.getEnd() != seqFeatureI2.getEnd()) {
            throw new FeatureInequalityException("Mismatched ends", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.strcmp(seqFeatureI.getResidues(), seqFeatureI2.getResidues())) {
            throw new FeatureInequalityException("Mismatched sequences", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.equals(seqFeatureI.getRefSequence(), seqFeatureI2.getRefSequence())) {
            throw new FeatureInequalityException("Mismatched sequences", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.strcmp(seqFeatureI.getRefId(), seqFeatureI2.getRefId())) {
            throw new FeatureInequalityException("Mismatched ref ids", seqFeatureI, seqFeatureI2);
        }
        if (seqFeatureI.getStrand() != seqFeatureI2.getStrand()) {
            throw new FeatureInequalityException("Mismatched strands", seqFeatureI, seqFeatureI2);
        }
        if (!seqFeatureI.getFeatureType().equals(seqFeatureI2.getFeatureType())) {
            throw new FeatureInequalityException("Mismatched types", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.strcmp(seqFeatureI.getProgramName(), seqFeatureI2.getProgramName())) {
            throw new FeatureInequalityException("Mismatched program names", seqFeatureI, seqFeatureI2);
        }
        if (!SeqFeatureUtil.scoreCompare(seqFeatureI.getScores(), seqFeatureI2.getScores())) {
            throw new FeatureInequalityException("Mismatched scores", seqFeatureI, seqFeatureI2);
        }
        if (seqFeatureI.getPhase() != seqFeatureI2.getPhase()) {
            throw new FeatureInequalityException("Mismatched phases", seqFeatureI, seqFeatureI2);
        }
        return true;
    }

    public static boolean strcmp(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public static boolean equals(SequenceI sequenceI, SequenceI sequenceI2) {
        if (sequenceI == null || sequenceI2 == null) {
            return sequenceI == sequenceI2;
        }
        if (!SeqFeatureUtil.strcmp(sequenceI.getAccessionNo(), sequenceI2.getAccessionNo())) {
            return false;
        }
        if (sequenceI.getLength() != sequenceI2.getLength()) {
            return false;
        }
        if (!SeqFeatureUtil.strcmp(sequenceI.getResidues(), sequenceI2.getResidues())) {
            return false;
        }
        return SeqFeatureUtil.strcmp(sequenceI.getDescription(), sequenceI2.getDescription());
    }

    public static boolean scoreCompare(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Score score = (Score)hashtable.get(string);
            Score score2 = (Score)hashtable2.get(string);
            if ((score == null || score2 == null) && score != score2) {
                return false;
            }
            if (score.getValue() == score2.getValue()) continue;
            return false;
        }
        return true;
    }

    public static Vector getFeatureVector(CurationSet curationSet) {
        Vector vector = SeqFeatureUtil.getFeatureVector(curationSet.getResults());
        Vector vector2 = SeqFeatureUtil.getFeatureVector(curationSet.getAnnots());
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(vector2.elementAt(i));
        }
        vector = VectorUtil.sort((Vector)vector, (org.bdgp.util.Comparator)new FeatureComparator());
        return vector;
    }

    public static Vector getFeatureVector(FeatureSetI featureSetI) {
        Vector<FeatureSetI> vector = new Vector<FeatureSetI>();
        for (int i = 0; i < featureSetI.getFeatures().size(); ++i) {
            FeatureSetI featureSetI2 = (FeatureSetI)featureSetI.getFeatures().elementAt(i);
            for (int j = 0; j < featureSetI2.getFeatures().size(); ++j) {
                FeatureSetI featureSetI3 = (FeatureSetI)featureSetI2.getFeatures().elementAt(j);
                vector.addElement(featureSetI3);
            }
        }
        return vector;
    }

    public static int binarySearch(Vector vector, Comparator comparator, Object object, boolean bl) {
        if (vector.size() == 0) {
            return -1;
        }
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = -1;
        while (n <= n2) {
            n3 = (n + n2) / 2;
            Object e = vector.elementAt(n3);
            int n4 = comparator.compare(e, object);
            if (bl) {
                boolean bl2;
                boolean bl3 = true;
                boolean bl4 = bl2 = n4 == 1;
                if (n3 > 0) {
                    boolean bl5 = bl3 = comparator.compare(object, vector.elementAt(n3 - 1)) != -1;
                }
                if (bl3 && bl2) {
                    return n3;
                }
            }
            if (n4 == 0) {
                if (bl) {
                    return n3 + 1;
                }
                return n3;
            }
            if (n4 == -1) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        if (bl) {
            return vector.size();
        }
        return -1;
    }

    public static Vector sortFeaturesAlphabetically(Vector vector) {
        Vector<SeqFeatureI> vector2 = new Vector<SeqFeatureI>();
        FeatureAlphabeticalComparator featureAlphabeticalComparator = new FeatureAlphabeticalComparator();
        for (int i = 0; i < vector.size(); ++i) {
            SeqFeatureI seqFeatureI = (SeqFeatureI)vector.elementAt(i);
            int n = SeqFeatureUtil.binarySearch(vector2, featureAlphabeticalComparator, seqFeatureI, true);
            if (n < 0) {
                n = 0;
            }
            if (n >= vector2.size()) {
                vector2.addElement(seqFeatureI);
                continue;
            }
            vector2.insertElementAt(seqFeatureI, n);
        }
        return vector2;
    }

    public static FeatureList getFeatPropLeafFeatures(CurationSet curationSet, FeatureProperty featureProperty) {
        FeatureList featureList = new FeatureList();
        for (int i = 0; i < featureProperty.getAnalysisTypesSize(); ++i) {
            String string = featureProperty.getAnalysisType(i);
            SeqFeatureUtil.debug("SFU getting leaves for analysis type " + string + " prop " + featureProperty);
            FeatureList featureList2 = curationSet.getAnalysisFeatureList(string);
            featureList.addAllFeatures(featureList2);
        }
        return featureList.getAllLeaves();
    }

    public static FeatureList getFeatPropLeafParentFeats(CurationSet curationSet, FeatureProperty featureProperty) {
        FeatureList featureList = SeqFeatureUtil.getFeatPropLeafFeatures(curationSet, featureProperty);
        FeatureList featureList2 = new FeatureList();
        for (int i = 0; i < featureList.size(); ++i) {
            featureList2.add(featureList.getFeature(i).getRefFeature());
        }
        return featureList2;
    }

    public static FeatureList getTranscripts(CurationSet curationSet) {
        return SeqFeatureUtil.getTranscripts(curationSet.getAnnots());
    }

    private static FeatureList getTranscripts(SeqFeatureI seqFeatureI) {
        FeatureList featureList = new FeatureList();
        if (seqFeatureI.getFeatureType().equals("transcript")) {
            featureList.addFeature(seqFeatureI);
        } else {
            for (int i = 0; i < seqFeatureI.getNumberOfChildren(); ++i) {
                featureList.addAll(SeqFeatureUtil.getTranscripts(seqFeatureI.getFeatureAt(i)));
            }
        }
        return featureList;
    }

    public static void debug(String string) {
        if (Config.DEBUG) {
            System.out.println(string);
        }
    }
}

