/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.config.Config;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.util.FeatureIterator;
import apollo.util.QuickSort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class FeatureList
extends ArrayList {
    private boolean featurePairsOnly = false;
    private boolean alignablesOnly = false;
    private boolean doUniqueCheck = true;

    public FeatureList() {
    }

    public FeatureList(int size) {
        super(size);
    }

    public FeatureList(Vector features) {
        this.addAll(features);
    }

    public FeatureList(boolean doUniqueCheck) {
        this.setDoUniqueCheck(doUniqueCheck);
    }

    public FeatureList(SeqFeatureI seqFeat, boolean addLeaves) {
        if (!addLeaves) {
            this.addFeature(seqFeat);
        } else {
            FeatureList fl = new FeatureList();
            fl.addFeature(seqFeat);
            this.addAllFeatures(fl.getAllLeaves());
        }
    }

    public void addFeature(SeqFeatureI feat) {
        this.add(feat);
    }

    public void setDoUniqueCheck(boolean doUniqueCheck) {
        this.doUniqueCheck = doUniqueCheck;
    }

    public void addAll(FeatureList feats) {
        for (int i = 0; i < feats.size(); ++i) {
            this.addFeature(feats.getFeature(i));
        }
    }

    public void removeFeature(SeqFeatureI feat) {
        this.remove(feat);
    }

    private void error(String m) {
        throw new RuntimeException(m);
    }

    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        boolean added = false;
        if (o instanceof SeqFeatureI) {
            SeqFeatureI sf = (SeqFeatureI)o;
            if (this.featurePairsOnly && !(sf instanceof FeaturePairI)) {
                return false;
            }
            if (this.alignablesOnly && !sf.hasAlignable()) {
                this.error("tried to add non alignable to alignable only feat list");
            }
            if (this.doUniqueCheck && this.contains(sf)) {
                return false;
            }
            added = super.add(o);
        } else if (Config.DEBUG) {
            System.err.println("FeatureList error, adding non SeqFeatureI " + o);
        }
        return added;
    }

    public FeatureIterator featureIterator() {
        return new FeatureIterator(this);
    }

    public SeqFeatureI getFeature(int index) {
        if (index >= this.size() || index < 0) {
            return null;
        }
        return (SeqFeatureI)this.get(index);
    }

    public SeqFeatureI last() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getFeature(this.size() - 1);
    }

    public SeqFeatureI first() {
        return this.getFeature(0);
    }

    public void addAllFeatures(FeatureList feats) {
        this.addAll(feats);
    }

    public FeatureList getParents() {
        FeatureList parents = new FeatureList();
        for (int i = 0; i < this.size(); ++i) {
            parents.addFeature(this.getFeature(i).getRefFeature());
        }
        return parents;
    }

    public FeatureList cloneList() {
        FeatureList clonedList = new FeatureList();
        for (int i = 0; i < this.size(); ++i) {
            clonedList.addFeature(this.getFeature(i).cloneFeature());
        }
        return clonedList;
    }

    public Vector toVector() {
        Vector v = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            v.addElement(this.get(i));
        }
        return v;
    }

    public void addVector(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            this.add(v.elementAt(i));
        }
    }

    public RangeI getRangeOfWholeList() {
        if (this.size() == 0) {
            return null;
        }
        int low = this.getFeature(0).getLow();
        int high = this.getFeature(0).getHigh();
        for (int i = 1; i < this.size(); ++i) {
            SeqFeatureI feat = this.getFeature(i);
            if (feat.getLow() < low) {
                low = feat.getLow();
            }
            if (feat.getHigh() <= high) continue;
            high = feat.getHigh();
        }
        if (this.getFeature(0).getStrand() == 1) {
            return new Range("no_name", low, high);
        }
        return new Range("no_name", high, low);
    }

    public FeatureList getAllLeaves() {
        return this.getAllLeaves(false);
    }

    public FeatureList getAllFeaturePairLeaves() {
        return this.getAllLeaves(true);
    }

    private FeatureList getAllLeaves(boolean justFeaturePairs) {
        FeatureList leaves = new FeatureList();
        leaves.setFeaturePairsOnly(justFeaturePairs);
        FeatureIterator iter = this.featureIterator();
        while (iter.hasNext()) {
            SeqFeatureI sf = iter.nextFeature();
            if (!sf.canHaveChildren()) {
                if (justFeaturePairs && !sf.hasHitFeature()) continue;
                leaves.addFeature(sf);
                continue;
            }
            FeatureList kids = new FeatureList(((FeatureSetI)sf).getFeatures());
            leaves.addAll(kids.getAllLeaves());
        }
        return leaves;
    }

    public FeatureList getFeatsWithAlignments() {
        FeatureList alignFeats = new FeatureList();
        FeatureIterator iter = this.featureIterator();
        while (iter.hasNext()) {
            SeqFeatureI feat = iter.nextFeature();
            if (!feat.hasAlignable()) continue;
            alignFeats.addFeature(feat);
        }
        return alignFeats;
    }

    public FeatureList getFeatsWithinRefSeqRegion() {
        FeatureList containedFeats = new FeatureList();
        FeatureIterator iter = this.featureIterator();
        while (iter.hasNext()) {
            SeqFeatureI feat = iter.nextFeature();
            if (!feat.isContainedByRefSeq()) continue;
            containedFeats.addFeature(feat);
        }
        return containedFeats;
    }

    public FeatureList getConsolidatedFeatures() {
        FeatureList consolidatedFeatures = new FeatureList(this.size());
        HashMap<FeatureSetI, Integer> parentToNumberOfKids = new HashMap<FeatureSetI, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            SeqFeatureI child = this.getFeature(i);
            FeatureSetI parent = child.getParent();
            if (this.isTopLevel(child)) {
                consolidatedFeatures.add(child);
                continue;
            }
            Integer numKids = new Integer(1);
            if (parentToNumberOfKids.containsKey(parent)) {
                numKids = (Integer)parentToNumberOfKids.get(parent);
                numKids = new Integer(numKids + 1);
            }
            parentToNumberOfKids.put(parent, numKids);
            if (numKids.intValue() == parent.getNumberOfChildren()) {
                Vector kids = parent.getFeatures();
                for (int j = 0; j < kids.size(); ++j) {
                    consolidatedFeatures.remove(kids.get(j));
                }
                consolidatedFeatures.add(parent);
                continue;
            }
            if (consolidatedFeatures.contains(parent)) continue;
            consolidatedFeatures.add(child);
        }
        return consolidatedFeatures;
    }

    private boolean isTopLevel(SeqFeatureI feat) {
        if (feat.getParent() == null) {
            return true;
        }
        if (!feat.hasAnnotatedFeature()) {
            return true;
        }
        return feat.getAnnotatedFeature().isAnnotTop();
    }

    public void sortByStart() {
        int i;
        int[] start = new int[this.size()];
        Object[] obj = new Object[this.size()];
        for (i = 0; i < this.size(); ++i) {
            start[i] = this.getLow(i);
            obj[i] = this.get(i);
        }
        QuickSort.sort(start, obj);
        for (i = 0; i < obj.length; ++i) {
            this.set(i, obj[i]);
        }
    }

    private int getLow(int i) {
        if (this.alignablesOnly) {
            return this.getAlignable(i).getLow();
        }
        return this.getFeature(i).getLow();
    }

    public void setFeaturePairsOnly(boolean featPairOnly) {
        this.featurePairsOnly = featPairOnly;
    }

    public void addFeaturePair(FeaturePairI featPair) {
        this.addFeature(featPair);
    }

    public FeatureList filterForFeaturePairs() {
        FeatureList featPairs = new FeatureList();
        featPairs.setFeaturePairsOnly(true);
        for (int i = 0; i < this.size(); ++i) {
            featPairs.addFeature(this.getFeature(i));
        }
        return featPairs;
    }

    public FeaturePairI getFeaturePair(int i) {
        if (!this.featurePairsOnly) {
            return null;
        }
        return (FeaturePairI)this.getFeature(i);
    }

    public String[] getUniqueHitNames() {
        if (!this.featurePairsOnly) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            names.add(this.getFeaturePair(i).getHitFeature().getName());
        }
        return names.toArray(new String[0]);
    }

    public void setAlignablesOnly(boolean alignablesOnly) {
        this.alignablesOnly = alignablesOnly;
    }

    public void addAlignable(SeqFeatureI alignable) {
        if (alignable == null) {
            return;
        }
        if (!this.contains(alignable)) {
            this.add(alignable);
        }
    }

    public SeqFeatureI getAlignable(int index) {
        if (!this.alignablesOnly) {
            this.error("Calling FeatList.getAlignable(i) on feat list thats not alignables");
        }
        return (SeqFeatureI)this.get(index);
    }

    public SeqFeatureI getFeatWithName(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getFeature(i).getName().equals(name)) continue;
            return this.getFeature(i);
        }
        return null;
    }
}

