/*
 * Decompiled with CFR 0.152.
 */
package apollo.main;

import apollo.config.Config;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CompositeDataHolder;
import apollo.editor.ResultChangeEvent;
import apollo.gui.ApolloFrame;
import apollo.gui.Controller;
import apollo.gui.ProgressFrame;
import apollo.gui.SwingWorker;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.main.DataLoader;
import java.awt.Cursor;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterException;

public class LoadUtil {
    private static final String loadUtilSource = "LOAD_UTIL";
    private static Object[] load_options = new Object[]{"Load anyway", "Save first, then load", "Cancel"};
    private static boolean finished = false;

    public static void loadWithProgress(ApolloFrame frame, String[] args, boolean new_curation) {
        LoadUtil.loadWithProgress(frame, true, args, null, new_curation);
    }

    public static void loadWithProgress(ApolloFrame frame, Properties props, boolean new_curation) {
        LoadUtil.loadWithProgress(frame, false, null, props, new_curation);
    }

    private static void loadWithProgress(final ApolloFrame frame, final boolean isArgs, final String[] args, final Properties props, final boolean new_curation) {
        final DataLoader loader = new DataLoader();
        if (new_curation && !LoadUtil.confirmSaved(load_options, loader)) {
            return;
        }
        final ProgressFrame pf = new ProgressFrame(frame, "Load progress");
        pf.setVisible(false);
        finished = false;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Vector<CompositeDataHolder> results = new Vector<CompositeDataHolder>(1);
                CompositeDataHolder compDataHolder = null;
                try {
                    if (!new_curation && isArgs) {
                        loader.addToCurationSet();
                        compDataHolder = LoadUtil.getCurationManager().getCompositeDataHolder();
                    } else {
                        compDataHolder = isArgs ? loader.getCompositeDataHolder(args, pf.getListener()) : loader.getCompositeDataHolder(props, pf.getListener());
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof DataAdapterException) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(frame, "This region couldn't be loaded because of the following problem: \n" + ex.getMessage(), "Warning", 2);
                    } else {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(frame, "Apollo has experienced an unexpected problem: \n" + ex.getMessage(), "Warning", 2);
                    }
                    ex.printStackTrace();
                }
                if (compDataHolder != null) {
                    results.addElement(compDataHolder);
                }
                frame.setCursor(Cursor.getPredefinedCursor(0));
                return results;
            }

            public void finished() {
                if (this.get() != null && ((Vector)this.get()).size() > 0) {
                    CompositeDataHolder compDataHolder = (CompositeDataHolder)((Vector)this.get()).elementAt(0);
                    try {
                        LoadUtil.doLoad(frame, loader, compDataHolder, new_curation);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage() + "\nPrinting stack trace: ");
                        ex.printStackTrace();
                        this.showFailDialog();
                    }
                }
                pf.dispose();
                frame.setCursor(Cursor.getPredefinedCursor(0));
                frame.invalidate();
                finished = true;
            }

            private void showFailDialog() {
                JOptionPane.showMessageDialog(frame, "Couldn't load region", "Warning", 2);
            }
        };
        worker.start();
    }

    private static void doLoad(ApolloFrame frame, DataLoader loader, CompositeDataHolder compDataHolder, boolean new_curation) throws DataAdapterException {
        if (compDataHolder != null) {
            if (new_curation) {
                CompositeApolloFrame caf = (CompositeApolloFrame)frame;
                caf.loadData(loader.getDataAdapter(), compDataHolder);
                Config.getController().setAnnotationChanged(false);
            } else {
                LoadUtil.fireResultChangeEvents();
            }
        }
        System.gc();
        frame.getGlassPane().setVisible(false);
    }

    private static boolean fireResultChangeEvents() {
        GuiCurationState curationState = LoadUtil.getCurationManager().getActiveCurState();
        StrandedZoomableApolloPanel szap = curationState.getSZAP();
        szap.setFeatureSet(szap.getCurationSet());
        szap.setAnnotations(szap.getCurationSet());
        szap.putVerticalScrollbarsAtStart();
        return true;
    }

    private static void fireResultChangeEvent(ResultChangeEvent evt) {
        Config.getController().handleResultChangeEvent(evt);
    }

    private static CurationManager getCurationManager() {
        return CurationManager.getCurationManager();
    }

    public static boolean confirmSaved(Object[] options, DataLoader loader) {
        boolean okay = !Controller.getMasterController().isAnnotationChanged();
        ApolloDataAdapterI adap = LoadUtil.getCurationManager().getDataAdapter();
        CompositeDataHolder cdh = LoadUtil.getCurationManager().getCompositeDataHolder();
        if (!okay) {
            JOptionPane pane = new JOptionPane("Annotations are changed", 3, 1, null, options, options[1]);
            JDialog dialog = pane.createDialog(ApolloFrame.getFrame(), "Please Confirm");
            dialog.show();
            Object result = pane.getValue();
            if (result != null) {
                if (options[0].equals(result)) {
                    okay = true;
                    boolean rollbackResult = adap.rollbackAnnotations(cdh);
                    rollbackResult = false;
                    if (false) {
                        JOptionPane.showConfirmDialog(ApolloFrame.getFrame(), "Attempted to roll back your annotation locks and failed");
                    }
                } else if (options[1].equals(result)) {
                    okay = loader.saveCompositeDataHolder(adap, cdh);
                }
            }
        } else {
            boolean rollbackResult = adap.rollbackAnnotations(cdh);
            rollbackResult = false;
            if (false) {
                JOptionPane.showConfirmDialog(ApolloFrame.getFrame(), "Attempted to roll back your annotation locks and failed");
            }
        }
        return okay;
    }

    public static boolean areYouSure(String question) {
        int answer;
        if (question == null || question.equals("")) {
            question = "Are you sure?";
        }
        JOptionPane pane = new JOptionPane(question, 3, 0);
        JDialog dialog = pane.createDialog(ApolloFrame.getFrame(), "Please Confirm");
        dialog.show();
        Object result = pane.getValue();
        return result != null && result instanceof Integer && (answer = ((Integer)result).intValue()) == 0;
    }
}

