/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.Config;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SpeciesComparison;
import apollo.gui.ApolloFrame;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.SyntenyLinkPanel;
import apollo.gui.synteny.SyntenyPanel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import org.bdgp.io.DataAdapterException;

public class CompositeApolloFrame
extends ApolloFrame {
    private ApolloDataAdapterI compositeAdapter;
    private HashMap linkPanels = new HashMap();
    private Color normalLabelColor = null;
    private Color selectedLabelColor = new Color(0, 153, 0);
    private static CompositeApolloFrame compositeApolloFrameSingleton;

    public static CompositeApolloFrame getApolloFrame() {
        if (compositeApolloFrameSingleton == null) {
            compositeApolloFrameSingleton = new CompositeApolloFrame();
        }
        return compositeApolloFrameSingleton;
    }

    private CompositeApolloFrame() {
    }

    public void loadData(ApolloDataAdapterI dataAdapter, CompositeDataHolder cdh) {
        CompositeApolloFrame.getCurationManager().setDataAdapter(dataAdapter);
        CompositeApolloFrame.getCurationManager().setCompositeDataHolder(cdh);
        this.initialiseApolloPanels(cdh);
        this.setTitle();
        CompositeApolloFrame.getCurationManager().selectInputFeatures();
        this.validate();
    }

    private void setTitle() {
        String title = "";
        title = CompositeApolloFrame.getCurationManager().isMultiCuration() ? "Synteny: " : this.getCompositeDataHolder().getCurationSet(0).getName();
        for (int i = 0; i < this.getCompositeDataHolder().numberOfSpecies(); ++i) {
            CurationSet currentSet = this.getCompositeDataHolder().getCurationSet(i);
            if (currentSet.getOrganism() == null || currentSet.getOrganism().equals("")) continue;
            if (i > 0) {
                title = title + " /";
            }
            title = title + " " + currentSet.getOrganism();
        }
        this.setTitle(title);
    }

    private void initialiseApolloPanels(CompositeDataHolder compositeDataHolder) {
        Vector<StrandedZoomableApolloPanel> orderedSingleSpeciesPanels = new Vector<StrandedZoomableApolloPanel>();
        Vector<SyntenyLinkPanel> orderedLinkPanels = new Vector<SyntenyLinkPanel>();
        for (int i = 0; i < compositeDataHolder.speciesCompSize(); ++i) {
            SyntenyLinkPanel currentLinkPanel;
            SpeciesComparison specComp = compositeDataHolder.getSpeciesComparison(i);
            StrandedZoomableApolloPanel firstPanel = this.getCurationState(i).getSZAP();
            if (orderedSingleSpeciesPanels.isEmpty()) {
                orderedSingleSpeciesPanels.addElement(firstPanel);
            }
            if (!specComp.hasSecondSpecies()) continue;
            StrandedZoomableApolloPanel secondPanel = this.getCurationState(i + 1).getSZAP();
            orderedSingleSpeciesPanels.addElement(secondPanel);
            if (!specComp.hasLinkSet()) continue;
            LinkSet currentLinkSet = compositeDataHolder.getLinkSet(i);
            if (this.getLinkPanels().containsKey(currentLinkSet.getName())) {
                currentLinkPanel = (SyntenyLinkPanel)this.getLinkPanels().get(currentLinkSet.getName());
            } else {
                currentLinkPanel = new SyntenyLinkPanel(firstPanel, secondPanel);
                this.getLinkPanels().put(currentLinkSet.getName(), currentLinkPanel);
            }
            currentLinkPanel.setLinks(currentLinkSet);
            firstPanel.getController().addListener(currentLinkPanel);
            secondPanel.getController().addListener(currentLinkPanel);
            currentLinkPanel.setStatusBar(CompositeApolloFrame.getCurationManager().getStatusBar());
            orderedLinkPanels.addElement(currentLinkPanel);
            Config.getStyle().getPropertyScheme().addPropSchemeChangeListener(firstPanel.getController());
            Config.getStyle().getPropertyScheme().addPropSchemeChangeListener(secondPanel.getController());
        }
        if (this.getSyntenyPanel() == null) {
            this.setSyntenyPanel(new SyntenyPanel(orderedSingleSpeciesPanels, orderedLinkPanels, this));
        } else {
            this.getSyntenyPanel().setPanels(orderedSingleSpeciesPanels, orderedLinkPanels);
        }
        CompositeApolloFrame.getCurationManager().addListenerToAllCurations(this.getSyntenyPanel());
    }

    private HashMap getLinkPanels() {
        return this.linkPanels;
    }

    private Color getNormalLabelColor() {
        return this.normalLabelColor;
    }

    private void setNormalLabelColor(Color color) {
        this.normalLabelColor = color;
    }

    private Color getSelectedLabelColor() {
        return this.selectedLabelColor;
    }

    private void setSelectedLabelColor(Color color) {
        this.selectedLabelColor = color;
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        Vector panels = this.getSyntenyPanel().getPanels();
        for (int i = 0; i < panels.size(); ++i) {
            ((StrandedZoomableApolloPanel)panels.get(i)).setVisible(true);
        }
    }

    public void setUseOpaqueLinks(boolean value) {
        this.getSyntenyPanel().setUseOpaqueLinks(value);
    }

    public void setShadeByPercId(boolean value) {
        this.getSyntenyPanel().setShadeByPercId(value);
    }

    public void loadSyntenyLink(SeqFeatureI link) {
        this.compositeAdapter = CurationManager.getCurationManager().getDataAdapter();
        try {
            this.compositeAdapter.loadNewSpeciesFromLink(link, this.getCompositeDataHolder());
        }
        catch (DataAdapterException e) {
            System.out.println("data adapter exception - do something...");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.loadData(this.compositeAdapter, this.getCompositeDataHolder());
    }

    public void setLockScrolling(boolean value) {
        this.getSyntenyPanel().setLockScrolling(value);
    }

    public void setShiftZoomLock(boolean state) {
        this.getSyntenyPanel().setShiftLockZoom(state);
    }
}

