/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.PropertyScheme;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.SeqFeatureUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class TranscriptMenu
extends JMenu {
    ApolloFrame frame;
    static /* synthetic */ Class class$apollo$datamodel$AnnotatedFeature;

    public TranscriptMenu(ApolloFrame frame) {
        super("Annotation");
        this.frame = frame;
        this.addMenuListener(new TranscriptMenuListener());
        frame.getController().addListener(new DataLoadListener(){

            public boolean handleDataLoadEvent(DataLoadEvent e) {
                TranscriptMenu.this.removeAll();
                return true;
            }
        });
    }

    public void menuInit() {
        this.removeAll();
        CurationSet cs = CurationManager.getCurationManager().getActiveCurState().getCurationSet();
        Vector features = SeqFeatureUtil.getFeaturesOfClass(cs.getAnnots(), class$apollo$datamodel$AnnotatedFeature == null ? (class$apollo$datamodel$AnnotatedFeature = TranscriptMenu.class$("apollo.datamodel.AnnotatedFeature")) : class$apollo$datamodel$AnnotatedFeature, false);
        int maxMenuLength = 25;
        if (features.size() > 0) {
            PropertyScheme scheme = Config.getPropertyScheme();
            features = SeqFeatureUtil.sortFeaturesAlphabetically(features);
            JMenu currentMenu = this;
            for (int i = 0; i < features.size(); ++i) {
                SeqFeatureI feature = (SeqFeatureI)features.elementAt(i);
                String name = feature.getName();
                JMenuItem menuItem = new JMenuItem(name + " " + (feature.getStrand() != -1 ? "(+)" : "(-)"));
                if (feature.getFeatureType().equalsIgnoreCase("gene")) {
                    String pep_status = feature.getProperty("sp_status");
                    menuItem.setFont(Config.getPeptideStatus(pep_status).getFont());
                } else {
                    menuItem.setFont(Config.getDefaultFeatureLabelFont());
                }
                if (feature instanceof AnnotatedFeatureI) {
                    AnnotatedFeatureI annot = (AnnotatedFeatureI)feature;
                    menuItem.setBackground(Config.getAnnotationColor(annot));
                } else {
                    menuItem.setBackground(scheme.getFeatureProperty(feature.getFeatureType()).getColour());
                }
                menuItem.addActionListener(new FocusMenuListener(feature));
                if (i > 0 && i % maxMenuLength == 0) {
                    JMenu submenu = new JMenu("More...");
                    currentMenu.add(submenu);
                    currentMenu = submenu;
                }
                currentMenu.add(menuItem);
            }
        } else {
            JMenuItem menuItem = new JMenuItem("<no annotations>");
            menuItem.setEnabled(false);
            this.add(menuItem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FocusMenuListener
    implements ActionListener {
        SeqFeatureI feature;

        public FocusMenuListener(SeqFeatureI feature) {
            this.feature = feature;
        }

        public void actionPerformed(ActionEvent e) {
            CurationManager cm = CurationManager.getCurationManager();
            for (int i = 0; i < cm.numberOfCurations(); ++i) {
                GuiCurationState cs = cm.getCurationState(i);
                if (this.feature.getFeatures().size() == 1) {
                    this.feature = (SeqFeatureI)this.feature.getFeatures().firstElement();
                }
                cs.getSelectionManager().select(this.feature, (Object)this);
                cs.getSZAP().zoomToSelectionWithWindow(Config.getGeneWindow());
            }
        }
    }

    private class TranscriptMenuListener
    implements MenuListener {
        private TranscriptMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            TranscriptMenu.this.menuInit();
        }
    }
}

