/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.PropertyScheme;
import apollo.gui.TypePanel;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class TiersMenu
extends JMenu
implements ActionListener,
DrawableAnnotationConstants {
    JMenuItem collapse;
    JMenuItem expand;
    JMenuItem showAllTiers;
    JMenuItem hideAllTiers;
    JMenuItem invertTiers;
    JMenuItem shrinkTiers;
    JMenuItem growTiers;
    public static JCheckBoxMenuItem types;

    public TiersMenu() {
        super("Tiers");
        this.menuInit();
    }

    public void menuInit() {
        types = new JCheckBoxMenuItem("Show types panel");
        this.collapse = new JMenuItem("Collapse all tiers");
        this.expand = new JMenuItem("Expand all tiers");
        this.showAllTiers = new JMenuItem("Show all tiers");
        this.hideAllTiers = new JMenuItem("Hide all tiers");
        this.invertTiers = new JMenuItem("Invert tier order");
        this.shrinkTiers = new JMenuItem("Decrease tier height (-)");
        this.growTiers = new JMenuItem("Increase tier height (+)");
        types.setState(this.getTypePanel().isVisible());
        this.getTypePanel().addWindowListener(new ItemWindowListener(types));
        this.add(types);
        this.addSeparator();
        this.add(this.collapse);
        this.add(this.expand);
        this.add(this.showAllTiers);
        this.add(this.hideAllTiers);
        this.add(this.invertTiers);
        this.addSeparator();
        this.add(this.shrinkTiers);
        this.add(this.growTiers);
        types.addActionListener(this);
        this.collapse.addActionListener(this);
        this.expand.addActionListener(this);
        this.showAllTiers.addActionListener(this);
        this.hideAllTiers.addActionListener(this);
        this.invertTiers.addActionListener(this);
        this.shrinkTiers.addActionListener(this);
        this.growTiers.addActionListener(this);
        this.collapse.setMnemonic('C');
        this.expand.setMnemonic('E');
        this.shrinkTiers.setMnemonic('-');
        this.growTiers.setMnemonic('+');
        this.collapse.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.expand.setAccelerator(KeyStroke.getKeyStroke(69, 2));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.collapse) {
            this.getActivePropScheme().expandAllTiers(false);
        } else if (e.getSource() == this.expand) {
            this.getActivePropScheme().expandAllTiers(true);
        } else if (e.getSource() == this.showAllTiers) {
            this.getActivePropScheme().setAllTiersVisible(true);
        } else if (e.getSource() == this.hideAllTiers) {
            this.getActivePropScheme().setAllTiersVisible(false);
        } else if (e.getSource() == this.invertTiers) {
            this.getSZAP().changeYOrientation();
        } else if (e.getSource() == this.shrinkTiers) {
            this.getSZAP().getApolloPanel().changeTierHeights(-1);
        } else if (e.getSource() == this.growTiers) {
            this.getSZAP().getApolloPanel().changeTierHeights(1);
        } else if (e.getSource() == types) {
            this.getTypePanel().setVisible(types.getState());
        }
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.getActiveCurState().getSZAP();
    }

    private PropertyScheme getActivePropScheme() {
        return this.getActiveCurState().getPropertyScheme();
    }

    private GuiCurationState getActiveCurState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    private TypePanel getTypePanel() {
        return TypePanel.getTypePanelInstance();
    }

    class ItemWindowListener
    extends WindowAdapter {
        JCheckBoxMenuItem item;

        public ItemWindowListener(JCheckBoxMenuItem item) {
            this.item = item;
        }

        public void windowClosing(WindowEvent e) {
            this.item.setState(false);
            ((Window)e.getSource()).removeWindowListener(this);
        }
    }
}

