/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.TierProperty;
import apollo.datamodel.LinkSet;
import apollo.gui.synteny.SyntenyLinkPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SyntenyLinkMenu
extends JPopupMenu
implements ActionListener {
    SyntenyLinkPanel synLinkPanel;
    JMenuItem scale;
    JCheckBoxMenuItem autoStraighten;
    private JMenuItem showJustDnaLinks;
    private JMenuItem showJustProteinLinks;
    private JMenuItem showBothLinkTypes;
    private JRadioButtonMenuItem showAllStrands;
    private JRadioButtonMenuItem plusPlusStrands;
    private JRadioButtonMenuItem minusMinusStrands;
    private JRadioButtonMenuItem plusMinusStrands;
    private JRadioButtonMenuItem minusPlusStrands;
    private JRadioButtonMenuItem clearStrandsInvisibleButton;
    private JMenuItem homeIn;
    private LinkSet selectedLinks;

    public SyntenyLinkMenu(SyntenyLinkPanel synLinkPanel, LinkSet selectedLinks) {
        super("Synteny Link");
        this.synLinkPanel = synLinkPanel;
        this.selectedLinks = selectedLinks;
        this.addPopupMenuListener(new LinkMenuListener());
        this.menuInit();
    }

    public void menuInit() {
        this.scale = new JMenuItem("Equalise ranges");
        this.autoStraighten = new JCheckBoxMenuItem("Auto straighten");
        this.showJustDnaLinks = new JMenuItem("Show just DNA links");
        this.showJustProteinLinks = new JMenuItem("Show just protein links");
        this.showBothLinkTypes = new JMenuItem("Show both protein and DNA links");
        this.showAllStrands = new JRadioButtonMenuItem("Show all strands");
        this.plusPlusStrands = new JRadioButtonMenuItem("Show +/+ strands");
        this.minusMinusStrands = new JRadioButtonMenuItem("Show -/- strands");
        this.plusMinusStrands = new JRadioButtonMenuItem("Show +/- strands");
        this.minusPlusStrands = new JRadioButtonMenuItem("Show -/+ strands");
        this.clearStrandsInvisibleButton = new JRadioButtonMenuItem();
        this.homeIn = new JMenuItem("Home in on selected link");
        this.add(this.scale);
        this.add(this.autoStraighten);
        this.add(this.showAllStrands);
        this.add(this.plusPlusStrands);
        this.add(this.minusMinusStrands);
        this.add(this.plusMinusStrands);
        this.add(this.minusPlusStrands);
        this.add(this.homeIn);
        this.homeIn.setEnabled(this.selectedLinks.size() == 1);
        ButtonGroup strandVisGroup = new ButtonGroup();
        strandVisGroup.add(this.showAllStrands);
        strandVisGroup.add(this.plusPlusStrands);
        strandVisGroup.add(this.minusMinusStrands);
        strandVisGroup.add(this.plusMinusStrands);
        strandVisGroup.add(this.minusPlusStrands);
        strandVisGroup.add(this.clearStrandsInvisibleButton);
        this.autoStraighten.setState(this.synLinkPanel.getAutoStraighten());
        this.scale.addActionListener(this);
        this.autoStraighten.addActionListener(this);
        this.showJustDnaLinks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.displayJustDnaLinks();
            }
        });
        this.showJustProteinLinks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.displayJustProteinLinks();
            }
        });
        this.showBothLinkTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.displayBothLinks();
            }
        });
        this.plusPlusStrands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.setSingleStrandVisibility(true, true);
            }
        });
        this.minusMinusStrands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.setSingleStrandVisibility(false, false);
            }
        });
        this.plusMinusStrands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.setSingleStrandVisibility(true, false);
            }
        });
        this.minusPlusStrands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.setSingleStrandVisibility(false, true);
            }
        });
        this.showAllStrands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.showAllStrands();
            }
        });
        this.homeIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SyntenyLinkMenu.this.synLinkPanel.homeInOnSelectedLink();
            }
        });
        this.addLinkVisibilityMenuItems();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.scale) {
            this.synLinkPanel.syncScales();
        } else if (e.getSource() == this.autoStraighten) {
            this.synLinkPanel.setAutoStraighten(this.autoStraighten.getState());
        }
    }

    private void addLinkVisibilityMenuItems() {
        int linkedTierPropsSize = Config.getPropertyScheme().getLinkedTierProps().size();
        for (int i = 0; i < linkedTierPropsSize; ++i) {
            final TierProperty tierProp = Config.getPropertyScheme().getLinkedTierProp(i);
            String s = "Show " + tierProp.getLabel();
            final JRadioButtonMenuItem linkVis = new JRadioButtonMenuItem(s);
            linkVis.setSelected(tierProp.isVisible());
            linkVis.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    tierProp.setVisible(linkVis.isSelected());
                }
            });
            this.add(linkVis);
        }
    }

    private class LinkMenuListener
    implements PopupMenuListener {
        private LinkMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            boolean topFor = SyntenyLinkMenu.this.synLinkPanel.isTopForwardVisible();
            boolean topRev = SyntenyLinkMenu.this.synLinkPanel.isTopReverseVisible();
            boolean botFor = SyntenyLinkMenu.this.synLinkPanel.isBottomForwardVisible();
            boolean botRev = SyntenyLinkMenu.this.synLinkPanel.isBottomReverseVisible();
            if (topFor && topRev && botFor && botRev) {
                SyntenyLinkMenu.this.showAllStrands.setSelected(true);
                return;
            }
            SyntenyLinkMenu.this.clearStrandsInvisibleButton.setSelected(true);
            if (topFor && topRev || botFor && botRev) {
                return;
            }
            SyntenyLinkMenu.this.plusPlusStrands.setSelected(topFor && botFor);
            SyntenyLinkMenu.this.plusMinusStrands.setSelected(topFor && botRev);
            SyntenyLinkMenu.this.minusPlusStrands.setSelected(topRev && botFor);
            SyntenyLinkMenu.this.minusMinusStrands.setSelected(topRev && botRev);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

