/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.PropertyScheme;
import apollo.gui.TierManagerI;
import apollo.gui.genomemap.FeatureTierManagerI;
import apollo.gui.genomemap.FeatureView;
import apollo.gui.genomemap.ViewI;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ShowMenu
extends JMenu
implements ActionListener {
    ViewI view;
    JMenuItem[] typeItems;

    public ShowMenu(ViewI view, Point pos) {
        super("Show hidden tier");
        this.view = view;
        this.menuInit();
    }

    private FeatureTierManagerI getViewManager() {
        FeatureView fv;
        TierManagerI tm;
        if (this.view instanceof FeatureView && (tm = (fv = (FeatureView)this.view).getTierManager()) instanceof FeatureTierManagerI) {
            return (FeatureTierManagerI)tm;
        }
        System.out.println("ERROR: No FFTM in ShowMenu");
        return null;
    }

    public void menuInit() {
        Vector types;
        FeatureTierManagerI fftm = this.getViewManager();
        this.setEnabled(false);
        if (fftm != null && (types = fftm.getHiddenTiers()).size() != 0) {
            this.setEnabled(true);
            this.typeItems = new JMenuItem[types.size()];
            PropertyScheme scheme = Config.getPropertyScheme();
            for (int i = 0; i < types.size(); ++i) {
                String type = (String)types.elementAt(i);
                this.typeItems[i] = new JMenuItem(type);
                this.add(this.typeItems[i]);
                this.typeItems[i].setBackground(scheme.getTierProperty(type).getColour());
                this.typeItems[i].addActionListener(this);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        FeatureTierManagerI fftm = this.getViewManager();
        if (fftm != null) {
            for (int i = 0; i < this.typeItems.length; ++i) {
                if (e.getSource() != this.typeItems[i]) continue;
                fftm.setVisible(e.getActionCommand(), true);
            }
            this.view.setInvalidity(true);
            this.view.getComponent().repaint(this.view.getBounds().x, this.view.getBounds().y, this.view.getBounds().width, this.view.getBounds().height);
        }
    }
}

