/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.gui.ApolloFrame;
import apollo.gui.Controller;
import apollo.gui.menus.AnalysisMenu;
import apollo.gui.menus.BookmarkMenu;
import apollo.gui.menus.EditMenu;
import apollo.gui.menus.FileMenu;
import apollo.gui.menus.HelpMenu;
import apollo.gui.menus.LinksMenu;
import apollo.gui.menus.SyntenyChoiceMenu;
import apollo.gui.menus.TiersMenu;
import apollo.gui.menus.TranscriptMenu;
import apollo.gui.menus.ViewMenu;
import apollo.gui.menus.WindowMenu;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import java.awt.Component;
import javax.swing.JMenuBar;

public class MenuManager {
    ApolloFrame frame;
    private JMenuBar menuBar;
    FileMenu fileMenu;
    EditMenu editMenu;
    public ViewMenu viewMenu;
    TiersMenu tiersMenu;
    TranscriptMenu transcriptMenu;
    WindowMenu windowMenu;
    BookmarkMenu bookmarkMenu;
    LinksMenu linksMenu;
    HelpMenu helpMenu;
    AnalysisMenu analysisMenu;
    SyntenyChoiceMenu syntenyMenu;
    private static final int syntenyMenuPosition = 8;
    private static MenuManager menuManagerSingleton;

    public static MenuManager createMenuManager(ApolloFrame af) {
        menuManagerSingleton = new MenuManager(af);
        return menuManagerSingleton;
    }

    private MenuManager(ApolloFrame frame) {
        this.frame = frame;
        this.menuInit();
        new MenuManagerDataLoadListener();
    }

    private void menuInit() {
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.fileMenu = new FileMenu(this.frame);
        this.editMenu = new EditMenu(this.frame);
        this.viewMenu = new ViewMenu(this.frame);
        this.tiersMenu = new TiersMenu();
        this.analysisMenu = new AnalysisMenu();
        this.transcriptMenu = new TranscriptMenu(this.frame);
        this.windowMenu = new WindowMenu(this.frame);
        this.bookmarkMenu = new BookmarkMenu();
        this.helpMenu = new HelpMenu(null);
        this.linksMenu = LinksMenu.getLinksMenu();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.tiersMenu);
        this.menuBar.add(this.analysisMenu);
        this.menuBar.add(this.bookmarkMenu);
        this.bookmarkMenu.setMnemonic('B');
        this.menuBar.add(this.transcriptMenu);
        this.transcriptMenu.setMnemonic('N');
        this.menuBar.add(this.windowMenu);
        if (CurationManager.getCurationManager().isMultiCuration()) {
            this.insertSyntenyMenu();
        }
        this.menuBar.add(this.linksMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.setMnemonic('F');
        this.editMenu.setMnemonic('E');
        this.viewMenu.setMnemonic('V');
        this.tiersMenu.setMnemonic('T');
        this.windowMenu.setMnemonic('W');
        this.linksMenu.setMnemonic('L');
        this.helpMenu.setMnemonic('H');
    }

    public void setHaveSequence(boolean haveSequence) {
        this.viewMenu.setHaveSequence(haveSequence);
    }

    public SyntenyChoiceMenu getSyntenyChoiceMenu() {
        return this.syntenyMenu;
    }

    private void insertSyntenyMenu() {
        if (this.syntenyMenuVisible()) {
            return;
        }
        this.syntenyMenu = new SyntenyChoiceMenu((CompositeApolloFrame)this.frame);
        this.menuBar.add((Component)this.syntenyMenu, 8);
        this.menuBar.validate();
    }

    private void removeSyntenyMenu() {
        if (!this.syntenyMenuVisible()) {
            return;
        }
        this.menuBar.remove(8);
        this.menuBar.validate();
    }

    private boolean syntenyMenuVisible() {
        if (this.syntenyMenu == null) {
            return false;
        }
        return this.menuBar.getMenu(8) == this.syntenyMenu;
    }

    private class MenuManagerDataLoadListener
    implements DataLoadListener {
        private MenuManagerDataLoadListener() {
            Controller.getMasterController().addListener(this);
        }

        public boolean handleDataLoadEvent(DataLoadEvent rce) {
            if (!rce.dataRetrievalDone()) {
                return false;
            }
            if (CurationManager.getCurationManager().isMultiCuration()) {
                MenuManager.this.insertSyntenyMenu();
            } else {
                MenuManager.this.removeSyntenyMenu();
            }
            return true;
        }
    }
}

