/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.gui.SliderWindow;
import apollo.gui.WindowScoreCalculator;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.GraphView;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GraphMenu
extends JPopupMenu
implements ActionListener {
    GraphView view;
    ApolloPanel ap;
    JMenuItem colour;
    JMenuItem windowSize;
    Point pos;

    public GraphMenu(ApolloPanel ap, GraphView view, Point pos) {
        super("Graph operations");
        this.ap = ap;
        this.view = view;
        this.pos = pos;
        this.menuInit();
    }

    public void menuInit() {
        this.colour = new JMenuItem("Plot colour ...");
        this.windowSize = new JMenuItem("Plot window length ...");
        this.add(this.colour);
        this.add(this.windowSize);
        if (!(this.view.getScoreCalculator() instanceof WindowScoreCalculator)) {
            this.windowSize.setEnabled(false);
        }
        this.colour.addActionListener(this);
        this.windowSize.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colour) {
            Color colour = JColorChooser.showDialog(this, "Change plot colour", this.view.getPlotColour());
            if (colour != null) {
                this.view.setPlotColour(colour);
            }
            this.ap.repaint();
        } else if (e.getSource() == this.windowSize) {
            WindowScoreCalculator wsc = (WindowScoreCalculator)this.view.getScoreCalculator();
            new SliderWindow("Change plot window length", "Window", wsc.getModel(), this.ap.getLocationOnScreen());
        }
    }
}

