/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.editor.FeatureChangeEvent;
import apollo.editor.FeatureChangeListener;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.bdgp.util.Comparator;
import org.bdgp.util.VectorUtil;

public class BookmarkMenu
extends JMenu {
    private JMenuItem addBookmark;
    private JMenuItem removeBookmark;
    FeatureComparator featureComparator = new FeatureComparator();
    private Vector bookmarks;

    BookmarkMenu() {
        super("Bookmarks");
        Controller.getMasterController().addListener(new FeatureDelListener());
        Controller.getMasterController().addListener(new DataLoadListener(){

            public boolean handleDataLoadEvent(DataLoadEvent e) {
                BookmarkMenu.this.bookmarks.clear();
                BookmarkMenu.this.removeAll();
                return true;
            }
        });
        this.bookmarks = new Vector();
        this.addBookmark = new JMenuItem("Add bookmark");
        this.removeBookmark = new JMenuItem("Remove bookmark");
        try {
            this.addBookmark.addActionListener(new AddBookmarkListener(this));
            this.removeBookmark.addActionListener(new RemoveBookmarkListener(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMenuListener(new BookmarkMenuListener());
    }

    private FeatureList getSelectedGenes() {
        GuiCurationState cs = CurationManager.getCurationManager().getActiveCurState();
        Selection selectedSpans = cs.getSelectionManager().getSelection();
        FeatureList uniqueAnnots = new FeatureList();
        for (int i = 0; i < ((ArrayList)selectedSpans).size(); ++i) {
            SeqFeatureI sf = selectedSpans.getFeature(i);
            if (sf instanceof ExonI) {
                AnnotatedFeatureI g = (AnnotatedFeatureI)sf.getRefFeature().getRefFeature();
                uniqueAnnots.addFeature(g);
                continue;
            }
            if (sf instanceof Transcript) {
                uniqueAnnots.addFeature(sf.getRefFeature());
                continue;
            }
            if (!sf.hasAnnotatedFeature()) continue;
            uniqueAnnots.addFeature(sf.getAnnotatedFeature());
        }
        return uniqueAnnots;
    }

    public void menuInit() {
        int i;
        FeatureList selected = this.getSelectedGenes();
        boolean allowRemove = false;
        boolean allowAdd = false;
        for (i = 0; i < selected.size(); ++i) {
            AnnotatedFeatureI g = (AnnotatedFeatureI)selected.getFeature(i);
            if (this.bookmarks.contains(g)) {
                allowRemove = true;
                if (!allowAdd) continue;
                break;
            }
            allowAdd = true;
            if (allowRemove) break;
        }
        this.addBookmark.setEnabled(allowAdd);
        this.removeBookmark.setEnabled(allowRemove);
        this.removeAll();
        this.add(this.addBookmark);
        this.add(this.removeBookmark);
        this.addSeparator();
        if (this.bookmarks.size() > 0) {
            for (i = 0; i < this.bookmarks.size(); ++i) {
                SeqFeatureI feature = (SeqFeatureI)this.bookmarks.elementAt(i);
                String name = feature.getName();
                name = name + " " + (feature.getStrand() != -1 ? "(+)" : "(-)");
                JMenuItem menuItem = new JMenuItem(name);
                menuItem.addActionListener(new FocusMenuListener(feature));
                this.add(menuItem);
            }
        } else {
            JMenuItem menuItem = new JMenuItem("<no bookmarks>");
            menuItem.setEnabled(false);
            this.add(menuItem);
        }
    }

    private class RemoveBookmarkListener
    implements ActionListener {
        BookmarkMenu bookmark_menu;

        public RemoveBookmarkListener(BookmarkMenu bmm) {
            this.bookmark_menu = bmm;
        }

        public void actionPerformed(ActionEvent e) {
            FeatureList genes = this.bookmark_menu.getSelectedGenes();
            for (int i = 0; i < genes.size(); ++i) {
                BookmarkMenu.this.bookmarks.removeElement(genes.getFeature(i));
            }
        }
    }

    private class AddBookmarkListener
    implements ActionListener {
        BookmarkMenu bookmark_menu;

        public AddBookmarkListener(BookmarkMenu bmm) {
            this.bookmark_menu = bmm;
        }

        public void actionPerformed(ActionEvent e) {
            FeatureList genes = this.bookmark_menu.getSelectedGenes();
            for (int i = 0; i < genes.size(); ++i) {
                BookmarkMenu.this.bookmarks.addElement(genes.getFeature(i));
            }
            VectorUtil.sort((Vector)BookmarkMenu.this.bookmarks, (Comparator)BookmarkMenu.this.featureComparator);
        }
    }

    private class FeatureDelListener
    implements FeatureChangeListener {
        private FeatureDelListener() {
        }

        public boolean handleFeatureChangeEvent(FeatureChangeEvent evt) {
            if (evt.isDelete() && evt.getChangeTop() instanceof AnnotatedFeatureI) {
                BookmarkMenu.this.bookmarks.removeElement(evt.getChangeTop());
            }
            return true;
        }
    }

    private class FocusMenuListener
    implements ActionListener {
        SeqFeatureI feature;

        public FocusMenuListener(SeqFeatureI feature) {
            this.feature = feature;
        }

        public void actionPerformed(ActionEvent e) {
            CurationManager cm = CurationManager.getCurationManager();
            for (int i = 0; i < cm.numberOfCurations(); ++i) {
                GuiCurationState cs = cm.getCurationState(i);
                cs.getSelectionManager().select(this.feature, (Object)this);
                cs.getSZAP().zoomToSelectionWithWindow(Config.getGeneWindow());
            }
        }
    }

    private class FeatureComparator
    implements Comparator {
        private FeatureComparator() {
        }

        public int compare(Object a, Object b) {
            SeqFeatureI sf1 = (SeqFeatureI)a;
            SeqFeatureI sf2 = (SeqFeatureI)b;
            if (sf1.getLow() < sf2.getLow()) {
                return -1;
            }
            if (sf1.getLow() > sf2.getLow()) {
                return 1;
            }
            return 0;
        }
    }

    private class BookmarkMenuListener
    implements MenuListener {
        private BookmarkMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            BookmarkMenu.this.menuInit();
        }
    }
}

