/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.DisplayPrefsI;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Exon;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.datamodel.seq.GAMESequence;
import apollo.editor.AnnotationEditor;
import apollo.editor.UserName;
import apollo.gui.ApolloFrame;
import apollo.gui.Selection;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.detailviewers.exonviewer.BaseFineEditor;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.FeatureTierManager;
import apollo.gui.menus.PeptideMenu;
import apollo.gui.menus.TypesMenu;
import apollo.gui.synteny.GuiCurationState;
import apollo.main.LoadUtil;
import apollo.util.HTMLUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class AnnotationMenu
extends JPopupMenu
implements ActionListener,
DrawableAnnotationConstants {
    ApolloPanelI ap;
    JMenuItem delete;
    JMenuItem annotInfo;
    JMenuItem baseedit;
    JMenuItem sequence;
    JMenuItem mergeExons;
    JMenuItem moveExonsToTranscript;
    JMenuItem mergeTran;
    JMenuItem splitExon;
    JMenuItem splitTran;
    JMenuItem fivePrime;
    JMenuItem threePrime;
    JMenuItem orf;
    JMenuItem setEnds;
    TypesMenu typesMenu;
    JMenuItem duplicateTranscript;
    JMenuItem showGeneReport;
    JMenuItem assignName;
    JMenuItem takeOwnership;
    JMenuItem toggleCompleted;
    PeptideMenu peptideStatusMenu;
    JMenuItem collapseTier;
    JMenuItem expandTier;
    JMenuItem changeColor;
    JMenuItem cancel;
    AnnotationView annotView;
    private GuiCurationState curationState;
    Selection selection;
    Vector transcripts = new Vector();
    Vector annots = new Vector();
    private Vector selectedAnnots;
    private FeatureSetI holder;
    Point pos;
    AnnotationEditor editor;
    boolean haveResidues = true;
    boolean haveWholeSeq = true;
    private int strand;

    public AnnotationMenu(GuiCurationState curationState, ApolloPanelI apolloPanel, AnnotationView annotView, Selection selection, Point pos) {
        super("Annotation");
        this.ap = apolloPanel;
        this.curationState = curationState;
        this.annotView = annotView;
        this.selection = selection;
        this.pos = pos;
        this.strand = annotView.getStrand();
        this.editor = annotView.getAnnotationEditor();
        this.editor.setSelections(annotView, selection, annotView.findFeatures(pos).toVector(), annotView.getTransform().toUser((Point)pos).x, annotView.getStrand());
        this.menuInit();
    }

    public void menuInit() {
        boolean haveAnnot;
        this.findTranscriptsAndAnnots(this.selection);
        this.holder = this.annotView.getTopModel();
        this.selectedAnnots = this.selection.getSelectionDescendedFromModel(this.holder).getSelectedVector();
        this.annotInfo = Config.isEditingEnabled() ? new JMenuItem("Annotation info editor...") : new JMenuItem("Annotation info...");
        this.baseedit = new JMenuItem("Exon detail editor...");
        this.sequence = new JMenuItem("Sequence...");
        this.delete = new JMenuItem("Delete selection");
        this.mergeExons = new JMenuItem("Merge exons");
        this.moveExonsToTranscript = new JMenuItem("Move exon(s) to transcript");
        this.mergeTran = new JMenuItem("Merge transcripts");
        this.splitExon = new JMenuItem("Split exon");
        this.splitTran = new JMenuItem("Split transcript");
        this.takeOwnership = new JMenuItem(this.getOwner(this.getFirstAnnot(this.selection)));
        this.toggleCompleted = new JMenuItem(this.getStatus(this.transcripts));
        this.peptideStatusMenu = new PeptideMenu(this.curationState);
        this.fivePrime = new JMenuItem("Set as 5' end");
        this.threePrime = new JMenuItem("Set as 3' end");
        this.setEnds = new JMenuItem("Set both ends");
        this.orf = new JMenuItem("Calculate longest ORF");
        this.duplicateTranscript = new JMenuItem("Duplicate transcript");
        this.showGeneReport = new JMenuItem("Get info about this feature via Web");
        this.typesMenu = new TypesMenu(this.editor);
        this.assignName = new JMenuItem("Assign name from evidence");
        this.changeColor = new JMenuItem("Change color of this feature type");
        this.collapseTier = new JMenuItem("Collapse tier");
        this.expandTier = new JMenuItem("Expand tier");
        this.cancel = new JMenuItem("Close menu");
        this.add(this.sequence);
        this.haveResidues = false;
        if (this.selectedAnnots.size() > 0) {
            SeqFeatureI lastFeat = (SeqFeatureI)this.selectedAnnots.elementAt(this.selectedAnnots.size() - 1);
            this.haveWholeSeq = lastFeat.isContainedByRefSeq();
            SequenceI seq = lastFeat.getRefSequence();
            this.haveResidues = seq instanceof GAMESequence ? ((GAMESequence)seq).hasSequence() : this.haveWholeSeq;
        }
        this.sequence.setEnabled(this.haveResidues && this.haveWholeSeq);
        this.add(this.showGeneReport);
        this.showGeneReport.setEnabled(this.selectedAnnots.size() > 0);
        this.add(this.annotInfo);
        this.annotInfo.setEnabled(this.selectedAnnots.size() > 0);
        boolean bl = haveAnnot = this.getFirstAnnot(this.selection) != null;
        if (Config.isEditingEnabled()) {
            this.add(this.baseedit);
            this.baseedit.setEnabled(this.haveResidues && this.haveWholeSeq && haveAnnot);
        }
        this.addSeparator();
        if (Config.isEditingEnabled()) {
            this.add(this.delete);
            this.delete.setEnabled(this.haveAnnots());
            this.add(this.mergeTran);
            this.mergeTran.setEnabled(this.editor.mergeTranscriptsAllowed());
            this.add(this.splitTran);
            this.splitTran.setEnabled(this.editor.splitTranscriptAllowed());
            this.add(this.duplicateTranscript);
            this.duplicateTranscript.setEnabled(this.transcripts.size() == 1);
            this.addSeparator();
            this.add(this.mergeExons);
            this.mergeExons.setEnabled(this.editor.mergeExonsAllowed());
            this.add(this.moveExonsToTranscript);
            this.moveExonsToTranscript.setEnabled(this.editor.moveExonsToTranscriptAllowed());
            this.add(this.splitExon);
            this.splitExon.setEnabled(this.editor.splitExonAllowed());
            this.add(this.typesMenu);
            this.typesMenu.setEnabled(this.editor.createAnnotationAllowed());
            this.addSeparator();
            this.add(this.orf);
            this.add(this.fivePrime);
            this.add(this.threePrime);
            this.add(this.setEnds);
            this.orf.setEnabled(this.transcripts.size() > 0);
            boolean trim_ends = this.editor.setExonTerminusAllowed();
            this.fivePrime.setEnabled(trim_ends);
            this.threePrime.setEnabled(trim_ends);
            this.setEnds.setEnabled(trim_ends);
            this.addSeparator();
        }
        if (Config.isEditingEnabled()) {
            AnnotatedFeatureI g;
            if (this.curationState.getStyle().showEvalOfPeptide() && this.annots.size() == 1 && (g = (AnnotatedFeatureI)this.annots.elementAt(0)).isProteinCodingGene()) {
                this.peptideStatusMenu.setGene(g);
                this.add(this.peptideStatusMenu);
            }
            if (this.curationState.getStyle().showOwnershipAnnotMenuItem()) {
                this.add(this.takeOwnership);
                this.takeOwnership.setEnabled(this.selectedAnnots.size() == 1);
            }
            if (this.curationState.getStyle().showTranscriptFinishedAnnotMenuItem()) {
                this.add(this.toggleCompleted);
                this.toggleCompleted.setEnabled(this.transcripts.size() > 0);
            }
        }
        this.changeColor.setEnabled(this.haveAnnots());
        this.collapseTier.setEnabled(this.haveAnnots());
        this.expandTier.setEnabled(this.haveAnnots());
        this.addSeparator();
        this.add(this.changeColor);
        this.add(this.collapseTier);
        this.add(this.expandTier);
        this.addSeparator();
        this.add(this.cancel);
        this.assignName.addActionListener(this);
        this.delete.addActionListener(this);
        this.annotInfo.addActionListener(this);
        this.baseedit.addActionListener(this);
        this.sequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SeqExport(AnnotationMenu.this.selection, AnnotationMenu.this.curationState.getController());
            }
        });
        this.splitExon.addActionListener(this);
        this.orf.addActionListener(this);
        this.fivePrime.addActionListener(this);
        this.threePrime.addActionListener(this);
        this.setEnds.addActionListener(this);
        this.mergeExons.addActionListener(this);
        this.mergeTran.addActionListener(this);
        this.splitTran.addActionListener(this);
        this.moveExonsToTranscript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationMenu.this.editor.moveExonsToTranscript();
            }
        });
        this.duplicateTranscript.addActionListener(this);
        this.showGeneReport.addActionListener(this);
        this.takeOwnership.addActionListener(this);
        this.toggleCompleted.addActionListener(this);
        this.cancel.addActionListener(this);
        this.delete.setMnemonic('D');
        this.annotInfo.setMnemonic('E');
        this.baseedit.setMnemonic('B');
        this.sequence.setMnemonic('T');
        this.mergeTran.setMnemonic('M');
        this.splitExon.setMnemonic('S');
        this.collapseTier.addActionListener(this);
        this.expandTier.addActionListener(this);
        this.changeColor.addActionListener(this);
        this.collapseTier.setMnemonic('O');
        this.expandTier.setMnemonic('P');
    }

    private ApolloFrame getApolloFrame() {
        return ApolloFrame.getApolloFrame();
    }

    public void actionPerformed(ActionEvent e) {
        FeatureTierManager tm = (FeatureTierManager)this.annotView.getTierManager();
        if (!(this.haveWholeSeq || e.getSource() != this.delete && e.getSource() != this.annotInfo && e.getSource() != this.baseedit && e.getSource() != this.mergeExons && e.getSource() != this.mergeTran && e.getSource() != this.splitExon && e.getSource() != this.splitTran && e.getSource() != this.moveExonsToTranscript && e.getSource() != this.takeOwnership && e.getSource() != this.toggleCompleted && e.getSource() != this.fivePrime && e.getSource() != this.threePrime && e.getSource() != this.setEnds && e.getSource() != this.duplicateTranscript && e.getSource() != this.assignName)) {
            String m = "WARNING: this transcript extends beyond the current sequence region,\nso any changes you make to it may not get saved in the database.\nEdit it at your own risk.\n";
            if (Config.internalMode()) {
                JOptionPane.showMessageDialog(null, m);
            } else {
                System.err.println(m);
            }
        }
        if (this.warnOnEdit() && (e.getSource() == this.delete || e.getSource() == this.baseedit || e.getSource() == this.mergeExons || e.getSource() == this.mergeTran || e.getSource() == this.splitExon || e.getSource() == this.splitTran || e.getSource() == this.moveExonsToTranscript || e.getSource() == this.fivePrime || e.getSource() == this.threePrime || e.getSource() == this.setEnds || e.getSource() == this.duplicateTranscript)) {
            if (!LoadUtil.areYouSure("Please note: the selected annotation is protected.\nAre you sure you want to edit it?")) {
                return;
            }
            System.out.println("User was warned against editing frozen annotation, but did so anyway.");
        }
        if (e.getSource() == this.delete) {
            this.editor.deleteSelectedFeatures();
        } else if (e.getSource() == this.annotInfo) {
            SeqFeatureI sf = (SeqFeatureI)this.selectedAnnots.elementAt(this.selectedAnnots.size() - 1);
            FeatureEditorDialog.showTextEditor(sf, this.curationState);
        } else if (e.getSource() == this.baseedit) {
            AnnotatedFeatureI gai = this.getFirstAnnot(this.selection);
            BaseFineEditor.showBaseEditor(gai, this.curationState, this.annotView.getGeneHolder());
        } else if (e.getSource() == this.splitExon) {
            this.editor.splitExon();
        } else if (e.getSource() == this.mergeExons) {
            this.editor.mergeExons();
        } else if (e.getSource() == this.mergeTran) {
            this.editor.mergeTranscripts();
        } else if (e.getSource() == this.splitTran) {
            this.editor.splitTranscript();
        } else if (e.getSource() == this.assignName) {
            this.editor.assignAnnotationName();
        } else if (e.getSource() == this.orf) {
            this.editor.setLongestORF();
        } else if (e.getSource() == this.fivePrime) {
            this.editor.setAs5Prime();
        } else if (e.getSource() == this.threePrime) {
            this.editor.setAs3Prime();
        } else if (e.getSource() == this.setEnds) {
            this.editor.setAsBothEnds();
        } else if (e.getSource() == this.duplicateTranscript) {
            this.editor.duplicateTranscript((Transcript)this.transcripts.elementAt(this.transcripts.size() - 1));
        } else if (e.getSource() == this.toggleCompleted) {
            this.toggleCompleted.setText(this.setStatus(this.transcripts));
        } else if (e.getSource() == this.takeOwnership) {
            this.takeOwnership.setText(this.setOwner(this.getFirstAnnot(this.selection)));
        } else if (e.getSource() == this.showGeneReport) {
            DisplayPrefsI displayPrefs = Config.getDisplayPrefs();
            if (this.selectedAnnots.size() > 0) {
                SeqFeatureI sf = (SeqFeatureI)this.selectedAnnots.elementAt(this.selectedAnnots.size() - 1);
                AnnotatedFeatureI topAnnot = this.getGeneLevelAnnot(sf);
                String url = displayPrefs.generateURL(topAnnot);
                if (url != null) {
                    System.out.println("Loading web page " + url);
                    HTMLUtil.loadIntoBrowser(url);
                } else {
                    JOptionPane.showMessageDialog(null, "Couldn't make URL for annotation " + topAnnot.getId());
                }
            }
        } else if (e.getSource() == this.collapseTier) {
            tm.collapseTier(this.annotView, this.ap);
        } else if (e.getSource() == this.expandTier) {
            tm.expandTier(this.annotView, this.ap);
        } else if (e.getSource() == this.changeColor) {
            tm.changeTypeColor(this.annotView, this.selection);
        }
        this.annotView.setInvalidity(true);
        this.annotView.getComponent().repaint(this.annotView.getBounds().x, this.annotView.getBounds().y, this.annotView.getBounds().width, this.annotView.getBounds().height);
    }

    private AnnotatedFeatureI getGeneLevelAnnot(SeqFeatureI sf) {
        while (sf != null && !this.holder.getFeatures().contains(sf)) {
            sf = sf.getParent();
        }
        if (sf != null && sf.hasAnnotatedFeature()) {
            return sf.getAnnotatedFeature();
        }
        return null;
    }

    private void findTranscriptsAndAnnots(Selection selection) {
        for (int i = 0; i < selection.size(); ++i) {
            SeqFeatureI feat = selection.getSelectedData(i);
            if (feat.getStrand() != this.strand) continue;
            if (feat.isExon()) {
                this.addTranscript(feat.getRefFeature());
                continue;
            }
            if (feat.isTranscript()) {
                this.addTranscript(feat);
                continue;
            }
            if (!feat.hasAnnotatedFeature()) continue;
            for (int j = 0; j < feat.getNumberOfChildren(); ++j) {
                this.addTranscript(feat.getFeatureAt(j));
            }
            this.addAnnot(feat);
        }
    }

    private void addTranscript(SeqFeatureI trans) {
        if (!this.transcripts.contains(trans)) {
            this.transcripts.add(trans);
        }
        this.addAnnot(trans.getRefFeature());
    }

    private void addAnnot(SeqFeatureI annot) {
        if (!this.annots.contains(annot)) {
            this.annots.add(annot);
        }
    }

    private boolean haveAnnots() {
        return !this.annots.isEmpty();
    }

    private AnnotatedFeatureI getFirstAnnot(Selection selection) {
        for (int i = 0; i < selection.size(); ++i) {
            SeqFeatureI feat = selection.getSelectedData(i);
            if (!(feat instanceof AnnotatedFeatureI) || feat.getStrand() != this.strand) continue;
            if (feat instanceof Exon) {
                feat = feat.getRefFeature();
            }
            return (AnnotatedFeatureI)feat;
        }
        return null;
    }

    public Vector findAnnots(Vector tran) {
        Vector<SeqFeatureI> genes = new Vector<SeqFeatureI>();
        for (int i = 0; i < tran.size(); ++i) {
            Transcript t = (Transcript)tran.elementAt(i);
            if (genes.contains(t.getRefFeature())) continue;
            genes.addElement(t.getRefFeature());
        }
        return genes;
    }

    private String setStatus(Vector transcripts) {
        Transcript t = (Transcript)transcripts.elementAt(transcripts.size() - 1);
        this.editor.setTranscriptStatus(t);
        return this.getStatus(transcripts);
    }

    private String getStatus(Vector transcripts) {
        String text;
        if (transcripts.size() == 1) {
            boolean status;
            Transcript t = (Transcript)transcripts.elementAt(transcripts.size() - 1);
            boolean bl = status = t.getProperty("status") != null && t.getProperty("status").equals("all done");
            text = status ? "Set " + t.getName() + " unfinished" : "Set " + t.getName() + " completed";
        } else {
            text = "Transcript status";
        }
        return text;
    }

    private String setOwner(AnnotatedFeatureI annot) {
        if (annot != null) {
            String owner = annot.getOwner();
            Vector<AnnotatedFeatureI> annotVector = new Vector<AnnotatedFeatureI>();
            annotVector.add(annot);
            if (owner == null || !owner.equals(UserName.getUserName())) {
                this.editor.takeOwnership(annotVector);
            } else {
                this.editor.disown(annotVector);
            }
        }
        return this.getOwner(annot);
    }

    private String getOwner(AnnotatedFeatureI annot) {
        String text;
        if (annot != null) {
            String owner = annot.getOwner();
            String ownersFullName = Config.getFullNameForUser(owner);
            String user = UserName.getUserName();
            String usersFullName = Config.getUsersFullName();
            text = owner == null ? "Set owner to " + usersFullName : (owner.equals(user) ? "Disown by " + ownersFullName : "Set owner to " + usersFullName + " (taking from " + ownersFullName + ")");
        } else {
            text = "Take ownership";
        }
        return text;
    }

    private boolean warnOnEdit() {
        if (this.transcripts == null || this.selectedAnnots == null || this.selectedAnnots.size() == 0) {
            return false;
        }
        if (this.transcripts.size() == 0) {
            return this.editor.warnOnEdit(this.selectedAnnots);
        }
        return this.editor.warnOnEdit(this.transcripts);
    }

    public void clear() {
        if (this.peptideStatusMenu != null) {
            this.peptideStatusMenu.clear();
        }
        this.peptideStatusMenu = null;
        this.editor = null;
        this.transcripts = null;
        this.annots = null;
        this.selectedAnnots = null;
        this.holder = null;
        this.removeAll();
    }
}

