/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ApolloJalviewEventBridge;
import apollo.gui.Controller;
import apollo.gui.DetailInfo;
import apollo.gui.Selection;
import apollo.util.FeatureList;
import jalview.gui.AlignFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

class AlignMenuItems {
    private FeatureSetI annotTop;
    private FeatureSetI resultTop;
    private Selection selection;
    private Controller apolloController;

    AlignMenuItems(FeatureSetI annots, FeatureSetI results, Selection selection, Controller c) {
        this.annotTop = annots;
        this.resultTop = results;
        this.selection = selection;
        this.apolloController = c;
    }

    JMenuItem getAlignSelectionMenuItem() {
        JMenuItem alignSelection = new JMenuItem("Align selected features...");
        alignSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignMenuItems.this.alignSelection();
            }
        });
        if (this.getSelectedFeatures().size() == 0) {
            alignSelection.setEnabled(false);
        }
        return alignSelection;
    }

    JMenuItem getAlignRegionMenuItem() {
        JMenuItem alignRegion = new JMenuItem("Align same type features in region...");
        alignRegion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignMenuItems.this.alignRegion();
            }
        });
        if (this.getSelectedFeatures().size() == 0) {
            alignRegion.setEnabled(false);
        }
        return alignRegion;
    }

    private void alignSelection() {
        FeatureList feats = this.filterFeatures(this.getSelectedFeatures());
        if (feats.size() == 0) {
            return;
        }
        this.putUpJalview(feats);
    }

    private FeatureList getSelectedFeatures() {
        FeatureList feats = this.selection.getListDescendedFromModel(this.resultTop, true);
        feats.addAllFeatures(this.selection.getListDescendedFromModel(this.annotTop, true));
        return feats;
    }

    private FeatureList filterFeatures(FeatureList selectedFeats) {
        FeatureList feats = selectedFeats.getAllLeaves().getFeatsWithAlignments();
        if (feats.size() == 0) {
            String m = "None of the features selected contain alignments";
            JOptionPane.showMessageDialog(null, m, "Warning", 2);
            return feats;
        }
        int featsPreviousSize = feats.size();
        feats = feats.getFeatsWithinRefSeqRegion();
        String msg = null;
        if (feats.size() == 0) {
            msg = "The features selected were outside of the entry region";
        } else if (feats.size() < featsPreviousSize) {
            msg = "Some of the features selected were outside of the entry region.  These will not be displayed in the alignment";
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(null, msg, "Warning", 2);
        }
        return feats;
    }

    private void putUpJalview(FeatureList feats) {
        if (feats.size() == 0) {
            System.out.println("No feats to align");
            return;
        }
        AlignFrame alignFrame = new AlignFrame(feats, false, true);
        alignFrame.setSize(750, 300);
        alignFrame.setTitle("AlignFrame");
        new ApolloJalviewEventBridge(this.apolloController, alignFrame.getController(), alignFrame);
        alignFrame.show();
    }

    private void alignRegion() {
        FeatureList feats = this.getFeatsInRegion(this.resultTop);
        feats.addAllFeatures(this.getFeatsInRegion(this.annotTop));
        feats = this.filterFeatures(feats);
        this.putUpJalview(feats);
    }

    private FeatureList getFeatsInRegion(FeatureSetI topModel) {
        FeatureList feats = new FeatureList();
        HashSet types = this.selection.getSelectedVisualTypes();
        FeatureList selFeats = this.selection.getListDescendedFromModel(topModel, true);
        if (!selFeats.isEmpty()) {
            RangeI featsRange = selFeats.getRangeOfWholeList();
            feats = this.getFeatsInRegion(topModel, featsRange, types);
        }
        return feats;
    }

    private FeatureList getFeatsInRegion(SeqFeatureI feat, RangeI range, HashSet types) {
        FeatureList feats = new FeatureList();
        if (feat.canHaveChildren()) {
            for (int i = 0; i < feat.getNumberOfChildren(); ++i) {
                FeatureList overlappingKids = this.getFeatsInRegion(feat.getFeatureAt(i), range, types);
                feats.addAllFeatures(overlappingKids);
            }
        } else if (feat.hasAlignable()) {
            if (feat.getLow() < range.getLow()) {
                return feats;
            }
            if (feat.getHigh() > range.getHigh()) {
                return feats;
            }
            if (feat.getStrand() != range.getStrand()) {
                return feats;
            }
            if (!this.featureHasSelectedType(feat, types)) {
                return feats;
            }
            feats.addFeature(feat);
        }
        return feats;
    }

    private boolean featureHasSelectedType(SeqFeatureI feat, HashSet types) {
        return types.contains(DetailInfo.getPropertyType(feat));
    }

    void clear() {
        this.annotTop = null;
    }
}

