/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableUtil;
import apollo.gui.event.TierManagerEvent;
import apollo.gui.event.TierManagerListener;
import apollo.gui.event.ViewEvent;
import apollo.gui.genomemap.DragView;
import apollo.gui.genomemap.DragViewI;
import apollo.gui.genomemap.DrawableTierManager;
import apollo.gui.genomemap.DropTargetViewI;
import apollo.gui.genomemap.FeatureTierManager;
import apollo.gui.genomemap.ManagedView;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.genomemap.TierViewI;
import apollo.util.FeatureList;
import apollo.util.SwingMissingUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public abstract class TierView
extends ManagedView
implements AdjustmentListener,
ControlledObjectI,
DropTargetViewI,
PickViewI,
TierManagerListener,
TierViewI {
    protected JScrollBar vScroll;
    protected boolean vscrollable = true;
    protected boolean rightSide = true;
    protected Controller controller;
    protected Vector dragSources = new Vector();
    private int rowCoordHeight = 0;
    protected SelectionManager selectionManager;
    private boolean scrollHack = false;
    private int drag_low;
    private int drag_high;

    public TierView(JComponent ap, String name, SelectionManager selectionManager) {
        super(ap, name, false);
        this.selectionManager = selectionManager;
        this.addScrollBar();
    }

    public void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public void setTierManager(FeatureTierManager ftm) {
        Controller c;
        if (this.manager != null && (c = this.manager.getController()) != null) {
            c.removeListener((EventListener)((Object)this.manager));
        }
        ftm.addTierManagerListener(this);
        super.setTierManager(ftm);
    }

    protected void updateManagerHeight() {
        if (this.manager != null) {
            super.updateManagerHeight();
            this.setScrollValues();
        }
    }

    public void moveScrollbarByWheelAmount(int nClick) {
        this.setScrollbarValue(this.getScrollbarValue() + nClick * this.rowCoordHeight);
    }

    public void setYOrientation(int direction) {
        boolean flipped = this.getTransform().getYOrientation() != direction && (direction == -1 || direction == 1);
        super.setYOrientation(direction);
        if (this.vscrollable && flipped && this.manager != null) {
            this.flipScrollBar();
        }
    }

    protected void addScrollBar() {
        this.vScroll = new JScrollBar();
        this.vScroll.setOrientation(1);
        this.vScroll.addAdjustmentListener(this);
        this.vScroll.setVisible(true);
        this.getComponent().add((Component)this.vScroll, "None");
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        this.setScrollVisibility(state);
    }

    public void paintView() {
        super.paintView();
        if (this.vscrollable) {
            Rectangle vb = new Rectangle(this.getBounds());
            vb.x = this.rightSide ? vb.x + vb.width - this.vScroll.getPreferredSize().width : 0;
            vb.width = this.vScroll.getPreferredSize().width;
            this.vScroll.setBounds(vb);
            this.vScroll.invalidate();
            this.vScroll.validate();
        }
    }

    private void flipScrollBar() {
        int newVal = this.vScroll.getMaximum() - this.vScroll.getValue() - this.vScroll.getVisibleAmount();
        this.vScroll.setValue(newVal);
    }

    public void setScrollSide(int side) {
        this.rightSide = side != -1;
    }

    public void incrementTierHeight() {
        this.changeTierHeight(1);
    }

    public void decrementTierHeight() {
        this.changeTierHeight(-1);
    }

    protected void changeTierHeight(int change) {
        if (change == 1) {
            this.manager.incrementTierHeight();
        } else {
            this.manager.decrementTierHeight();
        }
        this.updateManagerHeight();
        if (this.isVisible()) {
            this.getComponent().repaint();
        }
    }

    public void setLowestVisibleTier(long tier) {
        this.manager.setLowestVisible((int)tier);
        this.transformer.setYVisibleMinimum(this.manager.getMinimumVisibleTransformCoord());
        this.transformer.setYRange(this.getYRange());
        this.setInvalidity(true);
        if (this.isVisible()) {
            this.getComponent().repaint();
        }
    }

    public int getLowestVisibleTier() {
        return this.manager.getLowestVisible();
    }

    public boolean allowsTierDrags() {
        return true;
    }

    public boolean beginTierDrag(MouseEvent evt) {
        System.out.println("Need to override beginTierDrag!!!");
        return true;
    }

    public void updateTierDrag(MouseEvent evt) {
        System.out.println("Need to override updateTierDrag!!!");
    }

    public void endTierDrag(MouseEvent evt) {
        System.out.println("Need to override endTierDrag!!!");
    }

    public boolean handleTierManagerEvent(TierManagerEvent evt) {
        this.setScrollValues();
        this.setInvalidity(true);
        if (this.isVisible()) {
            this.getComponent().repaint();
        }
        return true;
    }

    public boolean interpretDrop(DragViewI dragView, MouseEvent evt) {
        return this.interpretDrop(dragView, evt, true, new StringBuffer());
    }

    public boolean interpretDrop(DragViewI dragView, MouseEvent evt, boolean doFlag, StringBuffer action) {
        if (!this.isValidDragSource(dragView.getOriginView())) {
            action.append("No action");
            return false;
        }
        return true;
    }

    public void registerDragSource(TierViewI view) {
        if (!this.dragSources.contains(view)) {
            this.dragSources.addElement(view);
        }
    }

    public boolean isValidDragSource(TierViewI view) {
        return this.dragSources.contains(view);
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (this.vscrollable && evt.getSource() == this.vScroll) {
            this.syncScrollbars();
        }
    }

    private void syncScrollbars() {
        if (this.vScroll == null) {
            try {
                throw new Exception("Failed syncScrollbar");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.scrollHack) {
            this.setLowestVisibleTier((long)this.vScroll.getMaximum() - (long)this.vScroll.getValue() - (long)this.manager.getNumVisible());
        } else {
            this.setLowestVisibleTier(this.scrollValueToTierNumber(this.vScroll.getValue()));
        }
    }

    private int scrollValueToTierNumber(int scrollValue) {
        if (this.isDownOrientation()) {
            return (int)this.manager.toTier(scrollValue);
        }
        int extent = (int)this.manager.getVisibleUserCoord();
        if (extent < 0) {
            extent = 0;
        }
        int scrollPlusExtent = scrollValue + extent;
        int tierToFlip = (int)this.manager.toTier(scrollPlusExtent);
        int forwardStrandTier = this.manager.getNumTiers() - tierToFlip;
        if (forwardStrandTier < 0) {
            forwardStrandTier = 0;
        }
        return forwardStrandTier;
    }

    protected boolean isDownOrientation() {
        return this.getTransform().getYOrientation() == 1;
    }

    protected boolean isUpOrientation() {
        return this.getTransform().getYOrientation() == -1;
    }

    protected void putScrollAtStart() {
        if (this.isUpOrientation()) {
            this.setScrollbarValue(this.getMaxScrollbarValue());
        }
        if (this.isDownOrientation()) {
            this.setScrollbarValue(this.getMinScrollbarValue());
        }
    }

    protected void setScrollbarValue(int val) {
        this.vScroll.setValue(val);
    }

    protected int getMaxScrollbarValue() {
        return this.vScroll.getMaximum();
    }

    protected int getVisibleScrollbarValue() {
        return this.vScroll.getVisibleAmount();
    }

    protected int getMinScrollbarValue() {
        return this.vScroll.getMinimum();
    }

    protected int getScrollbarValue() {
        return this.vScroll.getValue();
    }

    protected int getInvertedScrollbarValue() {
        return this.getMaxScrollbarValue() - (this.getScrollbarValue() + this.vScroll.getVisibleAmount());
    }

    public void setScrollHack(boolean value) {
        this.scrollHack = value;
    }

    public void setVScrollable(boolean state) {
        this.vscrollable = state;
    }

    public void fireViewEvent(int type) {
        ViewEvent evt = new ViewEvent(this.getComponent(), this, type);
        super.fireViewEvent(evt);
    }

    public void setScrollValues() {
        if (this.vscrollable && this.vScroll != null) {
            int oldval = this.vScroll.getValue();
            int oldvisible = this.vScroll.getVisibleAmount();
            this.vScroll.setMinimum(0);
            int maxUserCoord = (int)this.manager.getMaxUserCoord() + (int)this.manager.getMaxTierUserHeight();
            this.vScroll.setMaximum(maxUserCoord);
            int visCoord = (int)this.manager.getVisibleUserCoord();
            if (visCoord > maxUserCoord) {
                visCoord = maxUserCoord;
            }
            if (this.rowCoordHeight == 0) {
                this.rowCoordHeight = (int)this.manager.getMaxTierUserHeight();
                this.vScroll.setUnitIncrement(this.rowCoordHeight);
            }
            this.vScroll.setBlockIncrement(visCoord - this.rowCoordHeight);
            if (this.scrollHack && oldvisible != this.vScroll.getVisibleAmount()) {
                int bumpme = this.vScroll.getVisibleAmount() - oldvisible;
                this.vScroll.setValue(this.vScroll.getValue() - bumpme);
            }
            if (oldval > maxUserCoord - visCoord) {
                if (maxUserCoord - visCoord <= this.vScroll.getMinimum()) {
                    this.vScroll.setValue(this.vScroll.getMinimum());
                } else {
                    this.vScroll.setValue(maxUserCoord - visCoord);
                }
            }
            this.vScroll.setVisibleAmount(visCoord);
        }
    }

    public void printScrollValues() {
        System.out.println("vScroll params:-");
        System.out.println("  minimum " + this.vScroll.getMinimum());
        System.out.println("  maximum " + this.vScroll.getMaximum());
        System.out.println("  value   " + this.vScroll.getValue());
        System.out.println("  visam   " + this.vScroll.getVisibleAmount() + " nvistier " + this.manager.getNumVisible());
    }

    public void setScrollVisibility(boolean state) {
        if (this.vscrollable && this.vScroll != null) {
            this.vScroll.setVisible(state);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return SwingMissingUtil.getWindowAncestor(this.getComponent());
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void setController(Controller c) {
        this.controller = c;
        this.controller.addListener(this);
        if (this.getTierManager() != null) {
            this.getTierManager().setController(this.getController());
        }
    }

    public FeatureList findFeatures(Point pnt) {
        return this.findFeatures(this.getSelectionRectangle(pnt));
    }

    public FeatureList findFeatures(Vector rects) {
        FeatureList features = new FeatureList();
        for (int i = 0; i < rects.size(); ++i) {
            Rectangle rect = (Rectangle)rects.elementAt(i);
            features.addVector(this.findFeatures(rect).toVector());
        }
        return features;
    }

    public FeatureList findFeatures(Rectangle rect) {
        FeatureList features = new FeatureList();
        Vector these_features = this.findDrawables(rect);
        while (these_features.size() > 0) {
            Drawable se = (Drawable)these_features.elementAt(0);
            these_features.removeElement(se);
            features.addFeature(se.getFeature());
        }
        return features;
    }

    public Selection findFeaturesForSelection(Point p, boolean selectParents) {
        return this.findFeaturesForSelection(this.getSelectionRectangle(p), selectParents);
    }

    public Selection findFeaturesForSelection(Rectangle rect) {
        return this.findFeaturesForSelection(rect, false);
    }

    protected abstract Selection findFeaturesForSelection(Rectangle var1, boolean var2);

    public Vector findDrawables(Point pnt) {
        return this.findDrawables(this.getSelectionRectangle(pnt));
    }

    public Vector findDrawables(Rectangle rect) {
        return this.findDrawables(rect, false);
    }

    protected abstract Vector findDrawables(Rectangle var1, boolean var2);

    public void clear() {
        this.getComponent().remove(this.vScroll);
        this.vScroll.removeAdjustmentListener(this);
        this.vScroll = null;
        super.clear();
    }

    protected Vector drawablesForDrag(Selection selection) {
        Vector<Drawable> bundle = new Vector<Drawable>();
        for (int i = 0; i < selection.size(); ++i) {
            SeqFeatureI selFeat = selection.getSelectedData(i);
            if (i == 0 || selFeat.getLow() < this.drag_low) {
                this.drag_low = selFeat.getLow();
            }
            if (i == 0 || selFeat.getHigh() > this.drag_high) {
                this.drag_high = selFeat.getHigh();
            }
            Drawable dsf = DrawableUtil.createDrawable(selFeat);
            dsf.setFeature(selFeat);
            dsf.setVisible(true);
            dsf.setDrawn(true);
            bundle.add(dsf);
        }
        return bundle;
    }

    public abstract Selection getViewSelection(Selection var1);

    public DragViewI createDragView(MouseEvent evt, Selection view_selection) {
        if (view_selection.size() != 0) {
            Vector drawable_vect = this.drawablesForDrag(view_selection);
            Rectangle boxBounds = DrawableUtil.getBoxBounds(drawable_vect, this.transformer, this.manager);
            if (evt.getX() >= boxBounds.x && evt.getX() < boxBounds.x + boxBounds.width + 1) {
                Rectangle bounds = new Rectangle(evt.getX(), evt.getY(), boxBounds.width + 1, 20000);
                DragView dv = new DragView(this.getComponent(), "draggy", view_selection);
                dv.setBounds(bounds);
                dv.setOrigin(this, evt.getPoint());
                dv.setDrawables(drawable_vect);
                DrawableTierManager dm = new DrawableTierManager();
                dm.setDebug(true);
                dm.setTransformer(this.transformer);
                dm.setAggregateSizeChange(this.getTierManager().getAggregateSizeChange());
                dv.setTierManager(dm);
                int drag_right = this.transformer.getXOrientation() == 1 ? this.drag_high : this.drag_low;
                Point pixel_right = this.getTransform().toPixel(drag_right + 1, 0);
                int upper_limit = this.drag_high + (boxBounds.x + boxBounds.width + 1 - pixel_right.x) * (int)this.getTransform().getXCoordsPerPixel();
                dv.setLimits(new int[]{this.drag_low, upper_limit});
                dv.setYOrientation(this.getTransform().getYOrientation());
                dv.setXOrientation(this.getTransform().getXOrientation());
                dv.getTransform().setXVisibleMinimum(this.drag_low);
                dv.setRelativePosition(new Point(evt.getX() - boxBounds.x, 0));
                return dv;
            }
            return null;
        }
        return null;
    }
}

