/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.genomemap.ContainerView;
import apollo.gui.genomemap.ViewI;
import gov.sandia.postscript.PSGr2;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class SplitterView
extends ContainerView
implements MouseListener,
MouseMotionListener {
    protected ViewI v1;
    protected ViewI v2;
    protected Polygon splitPoly = new Polygon();
    protected Polygon splitBoundary = new Polygon();
    protected double splitFract = 0.5;
    protected Color triangleColor = Color.red;
    protected int triangleSize = 8;
    boolean currentV1Vis;
    boolean currentV2Vis;
    int start;
    double startFract;

    public SplitterView(JComponent ap, String name, boolean visible, ViewI v1, ViewI v2) {
        super(ap, name, visible);
        this.v1 = v1;
        this.v2 = v2;
        this.setViews();
        ap.addMouseListener(this);
        ap.addMouseMotionListener(this);
    }

    public void setLeftView(ViewI v1) {
        this.v1 = v1;
        this.setViews();
    }

    public ViewI getLeftView() {
        return this.v1;
    }

    public void setRightView(ViewI v2) {
        this.v2 = v2;
        this.setViews();
    }

    public ViewI getRightView() {
        return this.v2;
    }

    protected void setViews() {
        this.views.clear();
        this.views.add(this.v1);
        this.views.add(this.v2);
    }

    public Rectangle setScrollSpace(int where) {
        JScrollBar jb = new JScrollBar(1);
        int scrollWidth = jb.getMinimumSize().width;
        Rectangle rect = new Rectangle(this.getBounds());
        rect.width -= scrollWidth;
        if (where == -1) {
            rect.x += scrollWidth;
        }
        return rect;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.updateSplitFract();
        int splitPos = (int)((double)rect.height * this.splitFract);
        this.v1.setBounds(new Rectangle(rect.x, rect.y, rect.width, splitPos));
        this.v2.setBounds(new Rectangle(rect.x, rect.y + splitPos, rect.width, rect.height - splitPos));
    }

    protected void updateSplitFract() {
        if (!this.v1.isVisible() && this.v2.isVisible()) {
            this.splitFract = 0.0;
        } else if (this.v1.isVisible() && !this.v2.isVisible()) {
            this.splitFract = 1.0;
        }
        if (this.splitFract < 0.0) {
            this.splitFract = 0.0;
        }
        if (this.splitFract > 1.0) {
            this.splitFract = 1.0;
        }
        if (this.v1.isVisible() != this.currentV1Vis || this.v2.isVisible() != this.currentV2Vis) {
            if (this.v1.isVisible() && this.v2.isVisible()) {
                this.splitFract = 0.5;
            }
            this.currentV1Vis = this.v1.isVisible();
            this.currentV2Vis = this.v2.isVisible();
            this.setBounds(this.getBounds());
        }
    }

    public void resetSplitFract() {
        this.splitFract = 0.5;
    }

    public void paintView() {
        this.updateSplitFract();
        super.paintView();
        if (this.graphics instanceof PSGr2) {
            return;
        }
        this.graphics.setColor(this.triangleColor);
        this.splitPoly = new Polygon();
        this.splitBoundary = new Polygon();
        if (this.v1.isVisible() && this.v2.isVisible()) {
            Rectangle vb = this.transformer.getPixelBounds();
            int splitPos = (int)((double)vb.height * this.splitFract) + vb.y;
            int trianglePos = 0;
            this.splitPoly.addPoint(vb.x + trianglePos, splitPos - this.triangleSize / 2);
            this.splitPoly.addPoint(vb.x + trianglePos + this.triangleSize, splitPos);
            this.splitPoly.addPoint(vb.x + trianglePos, splitPos + this.triangleSize / 2);
            this.splitBoundary.addPoint(vb.x, splitPos - 2);
            this.splitBoundary.addPoint(vb.x + vb.width, splitPos - 2);
            this.splitBoundary.addPoint(vb.x + vb.width, splitPos + 2);
            this.splitBoundary.addPoint(vb.x, splitPos + 2);
            this.graphics.fillPolygon(this.splitPoly);
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (this.splitPoly.contains(evt.getPoint())) {
            this.start = evt.getPoint().y;
            this.startFract = this.splitFract;
        } else {
            this.start = -1;
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.start != -1) {
            this.splitFract = ((double)evt.getPoint().y - (double)this.start) / (double)this.viewBounds.height + this.startFract;
            this.updateSplitFract();
            this.setBounds(this.getBounds());
            this.getComponent().invalidate();
            this.getComponent().repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void invertViews() {
        ViewI tmp = this.v1;
        this.v1 = this.v2;
        this.v2 = tmp;
        this.splitFract = 1.0 - this.splitFract;
    }
}

