/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.genomemap.PixelMaskI;

public class PixelMask
implements PixelMaskI {
    boolean[][] mask;
    int size;
    int levels;

    public PixelMask(int levels, int size) {
        this.mask = new boolean[levels][size];
        this.size = size;
        this.levels = levels;
    }

    private boolean checkLimits(int start, int stop) {
        return start >= 0 && stop < this.size;
    }

    public void setPixelState(int pix, boolean state, int yindex) {
        if (this.checkLimits(pix, pix)) {
            this.mask[yindex][pix] = state;
        }
    }

    public void setPixelRangeState(int start, int stop, boolean state, int yindex) {
        int realStart = start < 0 ? 0 : start;
        int realStop = stop >= this.size ? this.size - 1 : stop;
        for (int i = realStart; i <= realStop; ++i) {
            this.mask[yindex][i] = state;
        }
    }

    public boolean isCompletelyObscured(int start, int stop, int yindex) {
        int realStart = start < 0 ? 0 : start;
        int realStop = stop >= this.size ? this.size - 1 : stop;
        for (int i = realStart; i <= realStop; ++i) {
            if (this.mask[yindex][i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "\nmask true vals: ";
        for (int y = 0; y < this.levels; ++y) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.mask[y][i]) continue;
                s = s + y + ":" + i + ",";
            }
        }
        return s + "\n";
    }
}

