/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.Selection;
import apollo.gui.SelectionManager;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import java.awt.event.MouseEvent;

class MouseManager {
    private ApolloPanel apolloPanel;
    private SelectionManager selectionManager;
    private GuiCurationState curationState;

    MouseManager(ApolloPanel ap, GuiCurationState cs) {
        this.apolloPanel = ap;
        this.curationState = cs;
        this.selectionManager = this.curationState.getSelectionManager();
    }

    void doLeftClick(MouseEvent evt) {
        if (!this.apolloPanel.focusIsSelectable()) {
            return;
        }
        PickViewI pickViewFocus = this.apolloPanel.getPickViewFocus();
        CurationManager.getCurationManager().setActiveCurState(this.getCurationState());
        boolean exclusiveSelection = false;
        if ((evt.getModifiers() & 1) == 0) {
            exclusiveSelection = true;
        }
        boolean selectParents = false;
        if (evt.getClickCount() == 2) {
            selectParents = true;
        }
        Selection newSelection = pickViewFocus.findFeaturesForSelection(evt.getPoint(), selectParents);
        this.selectionManager.select(newSelection, exclusiveSelection, this.apolloPanel);
    }

    private GuiCurationState getCurationState() {
        return this.curationState;
    }
}

