/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.genomemap.ColumnApolloLayout;
import apollo.gui.genomemap.ContainerView;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.genomemap.SplitterView;
import apollo.gui.genomemap.ViewI;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class LaidoutViewContainer
extends ContainerView
implements PickViewI {
    protected ColumnApolloLayout layout;

    public LaidoutViewContainer(JComponent ap, ColumnApolloLayout layout, String name) {
        super(ap, name, true);
        this.layout = layout;
    }

    public Rectangle setScrollSpace(int where) {
        JScrollBar jb = new JScrollBar(1);
        int scrollWidth = jb.getMinimumSize().width;
        Rectangle rect = new Rectangle(this.getBounds());
        rect.width -= scrollWidth;
        if (where == -1) {
            rect.x += scrollWidth;
        }
        return rect;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.layout.layoutViews(this.views, rect, this.getBounds().y);
    }

    public void add(ViewI v, Object constraints) {
        this.views.addElement(v);
        this.layout.addLayoutView(v, constraints);
    }

    public void addFirst(ViewI v, Object constraints) {
        this.views.insertElementAt(v, 0);
        this.layout.addLayoutView(v, constraints);
    }

    public void remove(ViewI v) {
        this.views.removeElement(v);
        this.layout.removeLayoutView(v);
    }

    public void invertViews() {
        Vector<ViewI> reverseViews = new Vector<ViewI>();
        for (int i = this.views.size() - 1; i >= 0; --i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof SplitterView) {
                ((SplitterView)v).invertViews();
            }
            reverseViews.addElement(v);
        }
        this.views = reverseViews;
    }
}

