/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.TierProperty;
import apollo.gui.TierManager;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.genomemap.DrawableTierManagerI;
import apollo.gui.genomemap.FeatureTier;
import java.util.Hashtable;
import java.util.Vector;

public class DrawableTierManager
extends TierManager
implements DrawableTierManagerI {
    protected Vector drawables;
    protected Hashtable tierhash = new Hashtable();
    protected boolean debug = false;
    protected Transformer transformer = null;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setTierData(Object data) {
        this.setDrawables((Vector)data);
    }

    public void fillTiers() {
        this.tiers.removeAllElements();
        this.tierhash.clear();
        if (this.drawables != null) {
            int drawable_count = this.drawables.size();
            for (int i = 0; i < drawable_count; ++i) {
                this.populateTier((Drawable)this.drawables.elementAt(i));
            }
        }
    }

    protected void setDrawables(Vector drawables) {
        this.drawables = drawables;
        this.doLayoutTiers();
    }

    protected void populateTier(Drawable dsf) {
        if (dsf.isVisible()) {
            if (dsf.isDrawn()) {
                FeatureProperty fp = dsf.getFeatureProperty();
                TierProperty tp = fp.getTier();
                if (this.ignoreScoreThresholds() || dsf.getFeature().getScore() >= (double)fp.getThreshold()) {
                    String label = "";
                    if (fp == null) {
                        System.out.println("Unable to find featureProperty for " + dsf.getFeature().getClass().getName() + " : " + dsf.getName() + " type " + dsf.getFeature().getTopLevelType());
                    }
                    if (tp == null) {
                        System.out.println("Unable to find TierProperty for " + fp.getDisplayType() + " : " + dsf.getName() + " type " + dsf.getFeature().getTopLevelType());
                    }
                    try {
                        label = tp.getLabel();
                    }
                    catch (Exception e) {
                        System.out.println("It is likely that the type description for " + fp.getDisplayType() + " is in your tiers file more than once.\n" + "Please fix your tiers file!");
                        return;
                    }
                    if (this.tierhash.containsKey(label)) {
                        FeatureTier tier = (FeatureTier)this.tierhash.get(label);
                        tier.addFeature(dsf, this.transformer);
                    } else {
                        FeatureTier tier = new FeatureTier();
                        this.tiers.addElement(tier);
                        this.tierhash.put(label, tier);
                        tier.addFeature(dsf, this.transformer);
                    }
                }
            } else if (dsf instanceof DrawableSetI) {
                DrawableSetI fs = (DrawableSetI)dsf;
                int fsSize = fs.size();
                for (int i = 0; i < fsSize; ++i) {
                    Drawable d = fs.getDrawableAt(i);
                    this.populateTier(d);
                }
            } else {
                System.err.println("DrawableTierManager.populateTier: ignoring unknown drawable of type " + dsf.getType() + ", name " + dsf.getName() + ", class " + dsf.getClass().getName());
                if (Config.DEBUG) {
                    new Throwable().printStackTrace();
                }
            }
        }
    }

    public void clearFeatures() {
        for (int i = 0; i < this.tiers.size(); ++i) {
            ((FeatureTier)this.tiers.elementAt(i)).clearDrawables();
        }
        this.tiers = new Vector();
        this.drawables = null;
        this.tierhash.clear();
    }

    public Vector getVisibleDrawables(int[] limits) {
        Vector visFeatures = new Vector();
        int lowestVisTier = this.getLowestVisible() < 0 ? 0 : this.getLowestVisible();
        int highestVisTier = this.getLowestVisible() + this.getNumVisible();
        if (highestVisTier < 0) {
            highestVisTier = 0;
        }
        if (highestVisTier > this.tiers.size()) {
            highestVisTier = this.tiers.size();
        }
        for (int i = lowestVisTier; i < highestVisTier; ++i) {
            Vector drawables = ((FeatureTier)this.tiers.elementAt(i)).getDrawables();
            Vector<Drawable> curVis = null;
            boolean beyondVisibleLimits = false;
            int featSize = drawables.size();
            for (int j = 0; j < featSize && !beyondVisibleLimits; ++j) {
                Drawable dsf = (Drawable)drawables.elementAt(j);
                dsf.setTierIndex(i);
                if (dsf.isVisible() && dsf.getHigh() >= limits[0] && dsf.getLow() <= limits[1]) {
                    if (curVis == null) {
                        curVis = new Vector<Drawable>();
                        visFeatures.addElement(curVis);
                    }
                    curVis.addElement(dsf);
                }
                beyondVisibleLimits = dsf.getLow() > limits[1];
            }
        }
        this.updateUserCoordBoundaries();
        return visFeatures;
    }
}

