/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.EvidenceFinder;
import apollo.datamodel.FeatureSetI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.AnnotationEditor;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.event.TierManagerEvent;
import apollo.gui.genomemap.ApolloLayoutManager;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.DragView;
import apollo.gui.genomemap.DragViewI;
import apollo.gui.genomemap.DropTargetViewI;
import apollo.gui.genomemap.FeatureView;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.SiteView;
import apollo.gui.menus.AnnotationMenu;
import apollo.gui.synteny.GuiCurationState;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class AnnotationView
extends FeatureView
implements ControlledObjectI,
DropTargetViewI,
AnnotationChangeListener {
    protected ResultView resultView;
    private EvidenceFinder finder;
    protected SiteView siteView;
    protected AnnotationEditor editor;
    private GuiCurationState curationState;
    private boolean editingEnabled = true;
    private AnnotationMenu annotMenu;

    public AnnotationView(JComponent component, String name, SelectionManager selectionManager, GuiCurationState curationState) {
        super(component, name, selectionManager);
        this.curationState = curationState;
        this.setDropSpaceSize(20);
        this.setBackgroundColour(Config.getAnnotationBackground());
    }

    public FeatureSetI getGeneHolder() {
        return this.dfset.getFeatureSet();
    }

    public FeatureSetI getTopModel() {
        return this.getGeneHolder();
    }

    public void setDrawableSet(DrawableSetI fset) {
        super.setDrawableSet(fset);
        this.editor = new AnnotationEditor(this.curationState, this.getGeneHolder());
        this.editor.setView(this);
        this.editor.setParentComponent(this.getComponent());
    }

    public boolean handleTierManagerEvent(TierManagerEvent evt) {
        this.setInvalidity(true);
        Hashtable vm = ((ApolloLayoutManager)this.getComponent().getLayout()).viewmap;
        String constraint = (String)vm.get(this);
        boolean heightUnconstrained = false;
        if (constraint != null) {
            boolean bl = heightUnconstrained = constraint.equals("None") || constraint.equals("Horizontal");
        }
        if (heightUnconstrained && this.getPreferredSize().height != this.getBounds().height) {
            this.getComponent().doLayout();
            return true;
        }
        return super.handleTierManagerEvent(evt);
    }

    public boolean allowsTierDrags() {
        return false;
    }

    public void annotDrag(DragViewI dragView, Vector annots, boolean doFlag, StringBuffer action) {
        if (dragView.getOriginView() == this && annots.size() > 0 && this.editor.mergeTranscriptsAllowed()) {
            if (doFlag) {
                this.editor.mergeTranscripts();
            }
            action.append("Merge transcripts");
        }
    }

    private void featureDrag(DragViewI dragView, Vector annots, boolean doFlag, StringBuffer action) {
        if (dragView.getOriginView() != this && !(dragView.getOriginView() instanceof AnnotationView)) {
            if (this.editor.addGeneOrTranscriptAllowed()) {
                if (doFlag) {
                    this.editor.addGeneOrTranscript();
                }
                action.append("Create new gene or transcript");
            } else if (this.editor.addExonsAllowed()) {
                if (doFlag) {
                    this.editor.addExons();
                }
                action.append("Add exon(s)");
            } else if (this.editor.addEvidenceExonsAllowed()) {
                if (doFlag) {
                    this.editor.addEvidenceExons();
                }
                action.append("Add evidence");
            }
        }
    }

    public void setEditingEnabled(boolean enable) {
        this.editingEnabled = enable;
    }

    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    public boolean interpretDrop(DragViewI dragView, MouseEvent evt) {
        StringBuffer action = new StringBuffer();
        return this.interpretDrop(dragView, evt, true, action);
    }

    public AnnotationEditor getAnnotationEditor() {
        return this.editor;
    }

    public boolean interpretDrop(DragViewI dragView, MouseEvent evt, boolean doFlag, StringBuffer action) {
        if (!this.editingEnabled) {
            return false;
        }
        if (super.interpretDrop(dragView, evt, doFlag, action)) {
            DragView dfv = (DragView)dragView;
            Vector shadowBoxes = dfv.collectShadows();
            Vector annots = this.findFeatures(shadowBoxes).toVector();
            this.editor.setSelections(this, dfv.getSelection(), annots, this.transformer.toUser((Point)evt.getPoint()).x, this.getStrand());
            if (dragView.getOriginView() instanceof SiteView && this.editor.setTranslationTerminusAllowed()) {
                if (doFlag) {
                    this.editor.setTranslationTerminus();
                }
                action.append("Set start/stop codon");
            } else if (!(dragView.getOriginView() instanceof SiteView)) {
                if (dragView.getOriginView() == this) {
                    this.annotDrag(dragView, annots, doFlag, action);
                } else {
                    this.featureDrag(dragView, annots, doFlag, action);
                }
            }
            if (action.length() == 0) {
                action.append("No action");
            }
            return true;
        }
        return false;
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        if (evt.isCompound()) {
            for (int i = 0; i < evt.getNumberOfChildren(); ++i) {
                this.handleAnnotationChangeEvent(evt.getChildChangeEvent(i));
            }
            return true;
        }
        AnnotatedFeatureI annot = evt.getAnnotTop();
        if (Config.DEBUG && !evt.isEndOfEditSession() && annot == null) {
            System.err.println("DEBUG: ACE with null annot!!!");
            new Throwable().printStackTrace();
        }
        if (annot != null && annot.getRefFeature() == null) {
            return false;
        }
        if (annot != null && (annot.getStrand() == this.getStrand() || annot.getStrand() == 0)) {
            this.dfset.repairFeatureSet(evt);
        }
        if (evt.isEndOfEditSession()) {
            this.manager.doLayoutTiers();
            this.visibleDrawables = this.getVisibleDrawables();
            return true;
        }
        return true;
    }

    public void setResultView(ResultView rv) {
        this.resultView = rv;
    }

    public EvidenceFinder getEvidenceFinder() {
        if (this.finder == null && this.resultView.getTopModel() != null) {
            this.finder = new EvidenceFinder(this.resultView.getTopModel());
        }
        return this.finder;
    }

    public ResultView getResultView() {
        return this.resultView;
    }

    public void setSiteView(SiteView sv) {
        this.siteView = sv;
    }

    public SiteView getSiteView() {
        return this.siteView;
    }

    protected void changeTierHeight(int change) {
        super.changeTierHeight(change);
        this.manager.doLayoutTiers();
    }

    protected boolean needsTextAvoidUpdate() {
        return this.manager != null;
    }

    protected JPopupMenu createPopupMenu(ApolloPanelI ap, MouseEvent evt) {
        if (this.annotMenu != null) {
            this.annotMenu.clear();
        }
        this.annotMenu = new AnnotationMenu(this.curationState, ap, this, ap.getSelection(), new Point(evt.getX(), evt.getY()));
        return this.annotMenu;
    }

    protected void clear(boolean justFeatures) {
        super.clear(justFeatures);
        if (this.annotMenu != null) {
            this.annotMenu.clear();
        }
        this.annotMenu = null;
        this.editor = null;
        this.finder = null;
    }

    protected void setCurationSet(CurationSet curation) {
        if (this.editor != null) {
            this.editor.setCurationSet(curation);
        }
    }

    public void setController(Controller c) {
        super.setController(c);
        if (this.editor != null) {
            this.editor.setController(c);
        }
    }
}

